/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.resources.attachments;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import java.net.URI;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.rest.DomainObjectFactory;
import org.xwiki.rest.XWikiResource;

@Path(value="/wikis/{wikiName}/spaces/{spaceName}/pages/{pageName}/attachments/{attachmentName}")
public class AttachmentResource
extends XWikiResource {
    @GET
    public Response getAttachment(@PathParam(value="wikiName") String wikiName, @PathParam(value="spaceName") String spaceName, @PathParam(value="pageName") String pageName, @PathParam(value="attachmentName") String attachmentName) throws XWikiException {
        XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
        Document doc = documentInfo.getDocument();
        Attachment xwikiAttachment = doc.getAttachment(attachmentName);
        if (xwikiAttachment == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return Response.ok().type(xwikiAttachment.getMimeType()).entity((Object)xwikiAttachment.getContent()).build();
    }

    @PUT
    public Response putAttachment(@PathParam(value="wikiName") String wikiName, @PathParam(value="spaceName") String spaceName, @PathParam(value="pageName") String pageName, @PathParam(value="attachmentName") String attachmentName, byte[] content) throws XWikiException {
        XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, true);
        Document doc = documentInfo.getDocument();
        if (!doc.hasAccessLevel("edit", this.xwikiUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        boolean existed = false;
        XWikiDocument xwikiDocument = this.xwiki.getDocument(doc.getPrefixedFullName(), this.xwikiContext);
        XWikiAttachment xwikiAttachment = xwikiDocument.getAttachment(attachmentName);
        if (xwikiAttachment == null) {
            xwikiAttachment = new XWikiAttachment();
            xwikiDocument.getAttachmentList().add(xwikiAttachment);
        } else {
            existed = true;
        }
        xwikiAttachment.setContent(content);
        xwikiAttachment.setAuthor(this.xwikiUser);
        xwikiAttachment.setFilename(attachmentName);
        xwikiAttachment.setDoc(xwikiDocument);
        xwikiDocument.saveAttachmentContent(xwikiAttachment, this.xwikiContext);
        doc.save();
        xwikiDocument = this.xwiki.getDocument(doc.getPrefixedFullName(), this.xwikiContext);
        String attachmentXWikiAbsoluteUrl = xwikiDocument.getExternalAttachmentURL(attachmentName, "download", this.xwikiContext).toString();
        String attachmentXWikiRelativeUrl = xwikiDocument.getAttachmentURL(attachmentName, "download", this.xwikiContext).toString();
        org.xwiki.rest.model.jaxb.Attachment attachment = DomainObjectFactory.createAttachment(this.objectFactory, this.uriInfo.getBaseUri(), new Attachment(doc, xwikiAttachment, this.xwikiContext), attachmentXWikiRelativeUrl, attachmentXWikiAbsoluteUrl);
        if (existed) {
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)attachment).build();
        }
        return Response.created((URI)this.uriInfo.getAbsolutePath()).entity((Object)attachment).build();
    }

    @DELETE
    public void deleteAttachment(@PathParam(value="wikiName") String wikiName, @PathParam(value="spaceName") String spaceName, @PathParam(value="pageName") String pageName, @PathParam(value="attachmentName") String attachmentName) throws XWikiException {
        XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, true);
        Document doc = documentInfo.getDocument();
        if (!doc.hasAccessLevel("edit", this.xwikiUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Attachment xwikiAttachment = doc.getAttachment(attachmentName);
        if (xwikiAttachment == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        XWikiDocument xwikiDocument = this.xwiki.getDocument(doc.getPrefixedFullName(), this.xwikiContext);
        XWikiAttachment baseXWikiAttachment = xwikiDocument.getAttachment(attachmentName);
        xwikiDocument.deleteAttachment(baseXWikiAttachment, this.xwikiContext);
        doc.save();
    }
}

