/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.resources.objects;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.xwiki.rest.DomainObjectFactory;
import org.xwiki.rest.RangeIterable;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.model.jaxb.Object;
import org.xwiki.rest.model.jaxb.Objects;
import org.xwiki.rest.model.jaxb.Property;
import org.xwiki.rest.resources.objects.ObjectResource;

@Path(value="/wikis/{wikiName}/spaces/{spaceName}/pages/{pageName}/objects")
public class ObjectsResource
extends XWikiResource {
    @GET
    public Objects getObjects(@PathParam(value="wikiName") String wikiName, @PathParam(value="spaceName") String spaceName, @PathParam(value="pageName") String pageName, @QueryParam(value="start") @DefaultValue(value="0") Integer start, @QueryParam(value="number") @DefaultValue(value="-1") Integer number) throws XWikiException {
        XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
        Document doc = documentInfo.getDocument();
        Objects objects = this.objectFactory.createObjects();
        ArrayList<BaseObject> objectList = new ArrayList<BaseObject>();
        XWikiDocument xwikiDocument = this.xwiki.getDocument(doc.getPrefixedFullName(), this.xwikiContext);
        Map classToObjectsMap = xwikiDocument.getxWikiObjects();
        for (String className : classToObjectsMap.keySet()) {
            Vector xwikiObjects = (Vector)classToObjectsMap.get(className);
            for (BaseObject object : xwikiObjects) {
                objectList.add(object);
            }
        }
        RangeIterable ri = new RangeIterable(objectList, start, number);
        for (BaseObject object : ri) {
            if (object == null) continue;
            objects.getObjectSummaries().add(DomainObjectFactory.createObjectSummary(this.objectFactory, this.uriInfo.getBaseUri(), this.xwikiContext, doc, object, false));
        }
        return objects;
    }

    @POST
    public Response addObject(@PathParam(value="wikiName") String wikiName, @PathParam(value="spaceName") String spaceName, @PathParam(value="pageName") String pageName, Object object) throws XWikiException {
        if (object.getClassName() == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
        Document doc = documentInfo.getDocument();
        if (!doc.hasAccessLevel("edit", this.xwikiUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        XWikiDocument xwikiDocument = this.xwiki.getDocument(doc.getPrefixedFullName(), this.xwikiContext);
        int objectNumber = xwikiDocument.createNewObject(object.getClassName(), this.xwikiContext);
        BaseObject xwikiObject = xwikiDocument.getObject(object.getClassName(), objectNumber);
        if (xwikiObject == null) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        BaseClass xwikiClass = this.xwiki.getClass(xwikiObject.getClassName(), this.xwikiContext);
        String[] arr$ = xwikiClass.getPropertyNames();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String propertyNameObject;
            String propertyName = propertyNameObject = arr$[i$];
            xwikiObject.set(propertyName, (java.lang.Object)"", this.xwikiContext);
        }
        for (Property property : object.getProperties()) {
            xwikiObject.set(property.getName(), (java.lang.Object)property.getValue(), this.xwikiContext);
        }
        doc.save();
        return Response.created((URI)UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(ObjectResource.class).build(new java.lang.Object[]{wikiName, spaceName, pageName, object.getClassName(), objectNumber})).entity((java.lang.Object)DomainObjectFactory.createObject(this.objectFactory, this.uriInfo.getBaseUri(), this.xwikiContext, doc, xwikiObject, false)).build();
    }
}

