/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.resources.pages;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.xwiki.query.QueryException;
import org.xwiki.rest.DomainObjectFactory;
import org.xwiki.rest.Utils;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.model.jaxb.Pages;

@Path(value="/wikis/{wikiName}/spaces/{spaceName}/pages/{pageName}/children")
public class PageChildrenResource
extends XWikiResource {
    @GET
    public Pages getPageChildren(@PathParam(value="wikiName") String wikiName, @PathParam(value="spaceName") String spaceName, @PathParam(value="pageName") String pageName, @QueryParam(value="start") @DefaultValue(value="0") Integer start, @QueryParam(value="number") @DefaultValue(value="-1") Integer number) throws XWikiException, QueryException {
        XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
        Document doc = documentInfo.getDocument();
        Pages pages = this.objectFactory.createPages();
        String queryString = "select distinct doc.fullName from XWikiDocument as doc where doc.parent = :parent order by doc.fullName asc";
        List childPageFullNames = this.queryManager.createQuery(queryString, "xwql").bindValue("parent", (Object)doc.getFullName()).setOffset(start.intValue()).setLimit(number.intValue()).execute();
        for (String childPageFullName : childPageFullNames) {
            String pageId = Utils.getPageId(wikiName, childPageFullName);
            if (!this.xwikiApi.exists(pageId)) {
                this.logger.warning(String.format("[Page '%s' appears to be in space '%s' but no information is available.]", pageName, spaceName));
                continue;
            }
            Document childDoc = this.xwikiApi.getDocument(pageId);
            if (childDoc == null) continue;
            pages.getPageSummaries().add(DomainObjectFactory.createPageSummary(this.objectFactory, this.uriInfo.getBaseUri(), childDoc, this.xwikiApi));
        }
        return pages;
    }
}

