/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.resources.spaces;

import com.xpn.xwiki.XWikiException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.UriBuilder;
import org.xwiki.query.QueryException;
import org.xwiki.rest.model.jaxb.SearchResults;
import org.xwiki.rest.resources.BaseSearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/wikis/{wikiName}/spaces/{spaceName}/search")
public class SpaceSearchResource
extends BaseSearchResult {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    public SearchResults search(@PathParam(value="wikiName") String wikiName, @PathParam(value="spaceName") String spaceName, @QueryParam(value="q") String keywords, @QueryParam(value="scope") List<String> searchScopeStrings, @QueryParam(value="number") @DefaultValue(value="-1") Integer number) throws QueryException, XWikiException {
        String database = this.xwikiContext.getDatabase();
        SearchResults searchResults = this.objectFactory.createSearchResults();
        searchResults.setTemplate(String.format("%s?q={keywords}(&scope={content|name|title|objects})*", UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(SpaceSearchResource.class).build(new Object[]{wikiName, spaceName}).toString()));
        try {
            this.xwikiContext.setDatabase(wikiName);
            ArrayList<BaseSearchResult.SearchScope> searchScopes = new ArrayList<BaseSearchResult.SearchScope>();
            for (String searchScopeString : searchScopeStrings) {
                if (searchScopeString == null || searchScopes.contains(searchScopeString)) continue;
                try {
                    BaseSearchResult.SearchScope searchScope = BaseSearchResult.SearchScope.valueOf(searchScopeString.toUpperCase());
                    searchScopes.add(searchScope);
                }
                catch (IllegalArgumentException e) {}
            }
            if (searchScopes.isEmpty()) {
                searchScopes.add(BaseSearchResult.SearchScope.CONTENT);
            }
            searchResults.getSearchResults().addAll(this.searchPages(searchScopes, keywords, wikiName, spaceName, this.xwiki.getRightService().hasProgrammingRights(this.xwikiContext), number));
            if (searchScopes.contains((Object)BaseSearchResult.SearchScope.OBJECTS)) {
                searchResults.getSearchResults().addAll(this.searchObjects(keywords, wikiName, spaceName, this.xwiki.getRightService().hasProgrammingRights(this.xwikiContext), number));
            }
        }
        finally {
            this.xwikiContext.setDatabase(database);
        }
        return searchResults;
    }
}

