/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.rest.resources.objects;

import java.util.List;

import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

import org.xwiki.component.annotation.Component;
import org.xwiki.rest.DomainObjectFactory;
import org.xwiki.rest.RangeIterable;
import org.xwiki.rest.Utils;
import org.xwiki.rest.model.jaxb.Objects;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;

/**
 * @version $Id: ObjectsAtPageVersionResource.java 25342 2009-11-27 20:10:28Z fmancinelli $
 */
@Component("org.xwiki.rest.resources.objects.ObjectsAtPageVersionResource")
@Path("/wikis/{wikiName}/spaces/{spaceName}/pages/{pageName}/history/{version}/objects")
public class ObjectsAtPageVersionResource extends BaseObjectsResource
{
    @GET
    public Objects getObjects(@PathParam("wikiName") String wikiName, @PathParam("spaceName") String spaceName,
        @PathParam("pageName") String pageName, @PathParam("version") String version,
        @QueryParam("start") @DefaultValue("0") Integer start, @QueryParam("number") @DefaultValue("-1") Integer number)
        throws XWikiException
    {
        DocumentInfo documentInfo = getDocumentInfo(wikiName, spaceName, pageName, null, version, true, false);

        Document doc = documentInfo.getDocument();

        Objects objects = objectFactory.createObjects();

        List<com.xpn.xwiki.objects.BaseObject> objectList = getBaseObjects(doc);

        RangeIterable<com.xpn.xwiki.objects.BaseObject> ri =
            new RangeIterable<com.xpn.xwiki.objects.BaseObject>(objectList, start, number);

        for (com.xpn.xwiki.objects.BaseObject object : ri) {
            /* By deleting objects, some of them might become null, so we must check for this */
            if (object != null) {
                objects.getObjectSummaries().add(
                    DomainObjectFactory.createObjectSummary(objectFactory, uriInfo.getBaseUri(), Utils
                        .getXWikiContext(componentManager), doc, object, true));
            }
        }

        return objects;
    }

}
