/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest;

import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeIterable<T>
implements Iterable<T> {
    private List<T> list;
    private int start;
    private int number;

    public RangeIterable(List<T> list, int start, int number) {
        this.list = list;
        if (start < 0) {
            start = 0;
        }
        if (start > list.size()) {
            start = list.size();
        }
        if (number < 0) {
            number = list.size();
        }
        if (start + number > list.size()) {
            number = list.size() - start;
        }
        this.start = start;
        this.number = number;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < RangeIterable.this.number && this.i + RangeIterable.this.start < RangeIterable.this.list.size();
            }

            @Override
            public T next() {
                Object result = RangeIterable.this.list.get(this.i + RangeIterable.this.start);
                ++this.i;
                return result;
            }

            @Override
            public void remove() {
            }
        };
    }
}

