/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.resources.comments;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.Object;
import java.net.URI;
import java.util.Date;
import java.util.Vector;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.DomainObjectFactory;
import org.xwiki.rest.RangeIterable;
import org.xwiki.rest.Utils;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.model.jaxb.Comment;
import org.xwiki.rest.model.jaxb.Comments;
import org.xwiki.rest.resources.comments.CommentResource;

@Component(value="org.xwiki.rest.resources.comments.CommentsResource")
@Path(value="/wikis/{wikiName}/spaces/{spaceName}/pages/{pageName}/comments")
public class CommentsResource
extends XWikiResource {
    @GET
    public Comments getComments(@PathParam(value="wikiName") String wikiName, @PathParam(value="spaceName") String spaceName, @PathParam(value="pageName") String pageName, @QueryParam(value="start") @DefaultValue(value="0") Integer start, @QueryParam(value="number") @DefaultValue(value="-1") Integer number) throws XWikiException {
        XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
        Document doc = documentInfo.getDocument();
        Comments comments = this.objectFactory.createComments();
        Vector xwikiComments = doc.getComments();
        RangeIterable ri = new RangeIterable(xwikiComments, start, number);
        for (Object xwikiComment : ri) {
            comments.getComments().add(DomainObjectFactory.createComment(this.objectFactory, this.uriInfo.getBaseUri(), doc, xwikiComment));
        }
        return comments;
    }

    @POST
    public Response postComment(@PathParam(value="wikiName") String wikiName, @PathParam(value="spaceName") String spaceName, @PathParam(value="pageName") String pageName, Comment comment) throws XWikiException {
        XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, true);
        Document doc = documentInfo.getDocument();
        int id = doc.createNewObject("XWiki.XWikiComments");
        Object commentObject = doc.getObject("XWiki.XWikiComments", id);
        commentObject.set("author", (java.lang.Object)Utils.getXWikiUser(this.componentManager));
        commentObject.set("date", (java.lang.Object)new Date());
        boolean save = false;
        if (comment.getHighlight() != null) {
            commentObject.set("highlight", (java.lang.Object)comment.getHighlight());
            save = true;
        }
        if (comment.getText() != null) {
            commentObject.set("comment", (java.lang.Object)comment.getText());
            save = true;
        }
        if (comment.getReplyTo() != null) {
            commentObject.set("replyto", (java.lang.Object)comment.getReplyTo());
        }
        if (save) {
            doc.save();
            Comment createdComment = DomainObjectFactory.createComment(this.objectFactory, this.uriInfo.getBaseUri(), doc, commentObject);
            return Response.created((URI)UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(CommentResource.class).build(new java.lang.Object[]{wikiName, spaceName, pageName, id})).entity((java.lang.Object)createdComment).build();
        }
        return null;
    }
}

