/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.resources.tags;

import com.xpn.xwiki.XWikiException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.UriBuilder;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.QueryException;
import org.xwiki.rest.Utils;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.Tag;
import org.xwiki.rest.model.jaxb.Tags;
import org.xwiki.rest.resources.tags.PagesForTagsResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="org.xwiki.rest.resources.tags.TagsResource")
@Path(value="/wikis/{wikiName}/tags")
public class TagsResource
extends XWikiResource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    public Tags getTags(@PathParam(value="wikiName") String wikiName) throws XWikiException, QueryException {
        String database = Utils.getXWikiContext(this.componentManager).getDatabase();
        Tags tags = this.objectFactory.createTags();
        try {
            Utils.getXWikiContext(this.componentManager).setDatabase(wikiName);
            List<String> tagNames = this.getAllTags();
            for (String tagName : tagNames) {
                Tag tag = this.objectFactory.createTag();
                tag.setName(tagName);
                String tagUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(PagesForTagsResource.class).build(new Object[]{wikiName, tagName}).toString();
                Link tagLink = this.objectFactory.createLink();
                tagLink.setHref(tagUri);
                tagLink.setRel("http://www.xwiki.org/rel/tag");
                tag.getLinks().add(tagLink);
                tags.getTags().add(tag);
            }
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setDatabase(database);
        }
        return tags;
    }

    private List<String> getAllTags() throws QueryException {
        String query = "select distinct elements(prop.list) from BaseObject as obj, DBStringListProperty as prop where obj.className='XWiki.TagClass' and obj.id=prop.id.id and prop.id.name='tags'";
        List tags = this.queryManager.createQuery(query, "hql").execute();
        Collections.sort(tags, String.CASE_INSENSITIVE_ORDER);
        return tags;
    }
}

