/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.user.api.XWikiUser;
import org.apache.commons.lang.StringUtils;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;

public class Utils {
    public static String getPageId(String wikiName, String spaceName, String pageName) {
        XWikiDocument xwikiDocument = new XWikiDocument();
        xwikiDocument.setDatabase(wikiName);
        xwikiDocument.setName(pageName);
        xwikiDocument.setSpace(spaceName);
        Document document = new Document(xwikiDocument, null);
        return document.getPrefixedFullName();
    }

    public static String getPageFullName(String wikiName, String spaceName, String pageName) {
        XWikiDocument xwikiDocument = new XWikiDocument();
        xwikiDocument.setDatabase(wikiName);
        xwikiDocument.setName(pageName);
        xwikiDocument.setSpace(spaceName);
        Document document = new Document(xwikiDocument, null);
        return document.getFullName();
    }

    public static String getObjectId(String wikiName, String spaceName, String pageName, String className, int objectNumber) {
        XWikiDocument xwikiDocument = new XWikiDocument();
        xwikiDocument.setDatabase(wikiName);
        xwikiDocument.setName(pageName);
        xwikiDocument.setSpace(spaceName);
        Document document = new Document(xwikiDocument, null);
        return String.format("%s:%s[%d]", document.getPrefixedFullName(), className, objectNumber);
    }

    public static String getPageId(String wikiName, String pageFullName) {
        XWikiDocument xwikiDocument = new XWikiDocument();
        xwikiDocument.setDatabase(wikiName);
        xwikiDocument.setFullName(pageFullName);
        Document document = new Document(xwikiDocument, null);
        return document.getPrefixedFullName();
    }

    public static Document getParentDocument(Document doc, com.xpn.xwiki.api.XWiki xwikiApi) throws XWikiException {
        if (StringUtils.isEmpty((String)doc.getParent())) {
            return null;
        }
        String parentName = doc.getParent();
        if (!parentName.contains(".")) {
            parentName = doc.getSpace() + "." + parentName;
        }
        return xwikiApi.getDocument(parentName);
    }

    public static XWikiContext getXWikiContext(ComponentManager componentManager) {
        Execution execution = null;
        XWikiContext xwikiContext = null;
        try {
            execution = (Execution)componentManager.lookup(Execution.class);
            xwikiContext = (XWikiContext)execution.getContext().getProperty("xwikicontext");
            return xwikiContext;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get XWiki context", e);
        }
    }

    public static XWiki getXWiki(ComponentManager componentManager) {
        return Utils.getXWikiContext(componentManager).getWiki();
    }

    public static com.xpn.xwiki.api.XWiki getXWikiApi(ComponentManager componentManager) {
        return new com.xpn.xwiki.api.XWiki(Utils.getXWiki(componentManager), Utils.getXWikiContext(componentManager));
    }

    public static String getXWikiUser(ComponentManager componentManager) {
        XWikiUser user = Utils.getXWikiContext(componentManager).getXWikiUser();
        if (user == null) {
            return "XWiki.Guest";
        }
        return user.getUser();
    }
}

