/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.gwt.api.client.dialog;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.xpn.xwiki.gwt.api.client.app.XWikiGWTApp;
import com.xpn.xwiki.gwt.api.client.dialog.ChoiceInfo;
import com.xpn.xwiki.gwt.api.client.dialog.Dialog;

public class ChoiceDialog
extends Dialog {
    FlowPanel buttonPanel = new FlowPanel();
    FlowPanel helpPanel = new FlowPanel();
    SimplePanel helpHeader = new SimplePanel();
    SimplePanel helpContent = new SimplePanel();
    boolean autoSelect;

    public ChoiceDialog(XWikiGWTApp app, String name, int buttonModes, boolean autoSelect) {
        this(app, name, buttonModes, autoSelect, null);
    }

    public ChoiceDialog(XWikiGWTApp app, String name, int buttonModes, boolean autoSelect, AsyncCallback nextCallback) {
        super(app, name, buttonModes, nextCallback);
        this.autoSelect = autoSelect;
        FlowPanel main = new FlowPanel();
        main.addStyleName(this.getCSSName("main"));
        HTMLPanel invitationPanel = new HTMLPanel(app.getTranslation(this.getDialogTranslationName() + ".invitation"));
        invitationPanel.addStyleName(this.getCssPrefix() + "-invitation");
        main.add((Widget)invitationPanel);
        this.buttonPanel.addStyleName(this.getCSSName("buttons"));
        main.add((Widget)this.buttonPanel);
        this.helpHeader.addStyleName(this.getCSSName("help", "head"));
        this.helpContent.addStyleName(this.getCSSName("help", "content"));
        this.helpPanel.addStyleName(this.getCSSName("help"));
        main.add((Widget)this.helpPanel);
        main.add((Widget)this.getActionsPanel());
        this.add((Widget)main);
    }

    public void addChoice(String name) {
        ChoiceInfo choiceinfo = new ChoiceInfo(this.app, this.getDialogTranslationName(), name);
        this.addChoice(choiceinfo);
    }

    public void addChoice(ChoiceInfo choice) {
        ChoiceButton button = new ChoiceButton(choice, new ClickListener(){

            public void onClick(Widget widget) {
                ChoiceDialog.this.onChoiceClick((ChoiceButton)widget);
            }
        });
        this.buttonPanel.add((Widget)button);
    }

    public void onChoiceClick(ChoiceButton choiceButton) {
        this.setCurrentResult(choiceButton.getChoiceInfo());
        if (this.autoSelect) {
            this.endDialog();
        } else {
            this.setActive(choiceButton);
            choiceButton.showDescription();
        }
    }

    private void setActive(Button button) {
        for (int i = 0; i < this.buttonPanel.getWidgetCount(); ++i) {
            Widget widget = this.buttonPanel.getWidget(i);
            if (!(widget instanceof ChoiceButton)) continue;
            ChoiceButton choiceButton = (ChoiceButton)widget;
            widget.removeStyleName(this.getCSSName("button", choiceButton.getChoiceInfo().getCSSName() + "-active"));
        }
        ((ChoiceButton)button).addStyleName(this.getCSSName("button", ((ChoiceButton)button).getChoiceInfo().getCSSName() + "-active"));
    }

    private class ChoiceButton
    extends Button {
        ChoiceInfo choiceInfo;

        public ChoiceButton(ChoiceInfo choiceInfo, ClickListener callback) {
            super(choiceInfo.getTitle(), callback);
            this.choiceInfo = choiceInfo;
            this.addStyleName(ChoiceDialog.this.getCSSName("button", choiceInfo.getCSSName()));
            this.sinkEvents(16);
        }

        public ChoiceInfo getChoiceInfo() {
            return this.choiceInfo;
        }

        public void onBrowserEvent(Event event) {
            switch (DOM.eventGetType((Event)event)) {
                case 16: {
                    if (!ChoiceDialog.this.autoSelect) break;
                    ChoiceDialog.this.setActive(this);
                    this.showDescription();
                }
            }
            super.onBrowserEvent(event);
        }

        public void showDescription() {
            ChoiceDialog.this.helpPanel.clear();
            HTMLPanel textPanel = new HTMLPanel(this.choiceInfo.getTitle());
            textPanel.setStyleName(ChoiceDialog.this.getCSSName("help", "content-text"));
            ChoiceDialog.this.helpPanel.add((Widget)textPanel);
            String imageURL = this.choiceInfo.getImageURL();
            Image image = new Image();
            image.setStyleName(ChoiceDialog.this.getCSSName("help", "content-image"));
            image.setTitle(this.choiceInfo.getTitle());
            if (imageURL != null && !imageURL.equals("")) {
                image.setUrl(imageURL);
            }
            ChoiceDialog.this.helpPanel.add((Widget)image);
            HTMLPanel descPanel = new HTMLPanel(this.choiceInfo.getDescription());
            descPanel.setStyleName(ChoiceDialog.this.getCSSName("help", "content-description"));
            ChoiceDialog.this.helpPanel.add((Widget)descPanel);
        }
    }
}

