/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package com.xpn.xwiki.wysiwyg.client.plugin.internal;

import java.util.HashMap;
import java.util.Map;

import com.xpn.xwiki.wysiwyg.client.plugin.PluginFactory;
import com.xpn.xwiki.wysiwyg.client.plugin.PluginFactoryManager;

/**
 * Default implementation of the {@link PluginFactoryManager}. We don't plan to provide another implementation.
 */
public final class DefaultPluginFactoryManager implements PluginFactoryManager
{
    /**
     * The map of registered factories. The key is the name of the plug-in, as returned by
     * {@link PluginFactory#getPluginName()}.
     */
    private Map<String, PluginFactory> factories = new HashMap<String, PluginFactory>();

    /**
     * {@inheritDoc}
     * 
     * @see PluginFactoryManager#addPluginFactory(PluginFactory)
     */
    public PluginFactory addPluginFactory(PluginFactory factory)
    {
        return factories.put(factory.getPluginName(), factory);
    }

    /**
     * {@inheritDoc}
     * 
     * @see PluginFactoryManager#getPluginFactory(String)
     */
    public PluginFactory getPluginFactory(String pluginName)
    {
        return factories.get(pluginName);
    }

    /**
     * {@inheritDoc}
     * 
     * @see PluginFactoryManager#removePluginFactory(String)
     */
    public PluginFactory removePluginFactory(String pluginName)
    {
        return factories.remove(pluginName);
    }
}
