/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package com.xpn.xwiki.wysiwyg.client.ui.cmd.internal;

import com.google.gwt.user.client.Element;
import com.xpn.xwiki.wysiwyg.client.ui.cmd.Executable;

public class DefaultExecutable extends AbstractExecutable
{
    protected String command;

    public DefaultExecutable(String command)
    {
        this.command = command;
    }

    /**
     * {@inheritDoc}
     * 
     * @see Executable#execute(Element, String)
     */
    public boolean execute(Element target, String parameter)
    {
        return execute(target, command, parameter);
    }

    /**
     * {@inheritDoc}
     * 
     * @see Executable#getParameter(Element)
     */
    public String getParameter(Element target)
    {
        return getParameter(target, command);
    }

    /**
     * {@inheritDoc}
     * 
     * @see Executable#isEnabled(Element)
     */
    public boolean isEnabled(Element target)
    {
        return isEnabled(target, command);
    }

    /**
     * {@inheritDoc}
     * 
     * @see Executable#isExecuted(Element)
     */
    public boolean isExecuted(Element target)
    {
        return isExecuted(target, command);
    }

    /**
     * {@inheritDoc}
     * 
     * @see Executable#isSupported(Element)
     */
    public boolean isSupported(Element target)
    {
        return isSupported(target, command);
    }
}
