/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package com.xpn.xwiki.wysiwyg.client.util;

import java.util.HashMap;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.Widget;
import com.xpn.xwiki.wysiwyg.client.widget.rta.RichTextArea;

/**
 * Associates {@link Command}s to shortcut keys.<br/>
 * NOTE: This class currently works only with {@link RichTextArea} because of a GWT issue that prevents us from
 * accessing the current event.
 * 
 * @version $Id: ShortcutKeyManager.java 20039 2009-05-16 12:04:30Z sdumitriu $
 * @see http://code.google.com/p/google-web-toolkit/issues/detail?id=3133
 */
public class ShortcutKeyManager extends HashMap<ShortcutKey, Command> implements KeyboardListener
{
    /**
     * Field required by all {@link java.io.Serializable} classes.
     */
    private static final long serialVersionUID = 4703900727850408738L;

    /**
     * {@inheritDoc}
     * 
     * @see KeyboardListener#onKeyDown(Widget, char, int)
     */
    public void onKeyDown(Widget sender, char keyCode, int modifiers)
    {
        Command command = get(new ShortcutKey(keyCode, modifiers));
        if (command != null) {
            // Prevent default browser behavior.
            ((RichTextArea) sender).getCurrentEvent().xPreventDefault();
            // Schedule command.
            DeferredCommand.addCommand(command);
        }
    }

    /**
     * {@inheritDoc}
     * 
     * @see KeyboardListener#onKeyPress(Widget, char, int)
     */
    public void onKeyPress(Widget sender, char keyCode, int modifiers)
    {
        // NOTE: It seems the key modifiers are not detected on this event.
    }

    /**
     * {@inheritDoc}
     * 
     * @see KeyboardListener#onKeyUp(Widget, char, int)
     */
    public void onKeyUp(Widget sender, char keyCode, int modifiers)
    {
        // NOTE: It seems that KeyboardListener#MODIFIER_META is not detected on apple keyboards (where it is mapped to
        // apple command key) for this event. We have to detect it on key down.
    }
}
