/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.resources.domain;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.domain.DavPage;
import com.xpn.xwiki.plugin.webdav.resources.partial.AbstractDavFile;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;

public class DavAttachment
extends AbstractDavFile {
    private XWikiAttachment attachment;

    public void init(XWikiDavResource parent, String name, String relativePath) throws DavException {
        super.init(parent, name, relativePath);
        if (parent.exists()) {
            this.attachment = ((DavPage)parent).getDocument().getAttachment(this.name);
        }
        if (this.exists()) {
            String timeStamp = DavConstants.creationDateFormat.format(this.attachment.getDate());
            this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.CREATIONDATE, (Object)timeStamp));
            timeStamp = DavConstants.modificationDateFormat.format(this.attachment.getDate());
            this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETLASTMODIFIED, (Object)timeStamp));
            this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETETAG, (Object)timeStamp));
            this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTTYPE, (Object)this.attachment.getMimeType(this.xwikiContext)));
            this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLANGUAGE, (Object)this.attachment.getDoc().getLanguage()));
            this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLENGTH, (Object)this.attachment.getFilesize()));
        }
    }

    public boolean exists() {
        return this.attachment != null;
    }

    public void spool(OutputContext outputContext) throws IOException {
        OutputStream out;
        if (this.exists() && null != (out = outputContext.getOutputStream())) {
            try {
                out.write(this.attachment.getContent(this.xwikiContext));
                out.flush();
            }
            catch (XWikiException ex) {
                throw new IOException(ex.getFullMessage());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void move(DavResource destination) throws DavException {
        if (!(destination instanceof DavAttachment)) throw new DavException(400);
        DavAttachment dAttachment = (DavAttachment)destination;
        if (dAttachment.getCollection().equals(this.getCollection())) {
            try {
                XWikiDocument owner = this.attachment.getDoc();
                owner.deleteAttachment(this.attachment, this.xwikiContext);
                this.attachment.setFilename(dAttachment.getDisplayName());
                owner.getAttachmentList().add(this.attachment);
                this.attachment.setDoc(owner);
                owner.saveAttachmentContent(this.attachment, this.xwikiContext);
                this.xwikiContext.getWiki().saveDocument(owner, this.xwikiContext);
                return;
            }
            catch (XWikiException e) {
                throw new DavException(500, (Throwable)e);
            }
        }
        if (!(dAttachment.getCollection() instanceof DavPage)) throw new DavException(400);
        XWikiDocument dDoc = ((DavPage)dAttachment.getCollection()).getDocument();
        try {
            XWikiDocument owner = this.attachment.getDoc();
            owner.deleteAttachment(this.attachment, this.xwikiContext);
            this.xwikiContext.getWiki().saveDocument(owner, this.xwikiContext);
            this.attachment.setFilename(dAttachment.getDisplayName());
            dDoc.getAttachmentList().add(this.attachment);
            this.attachment.setDoc(dDoc);
            dDoc.saveAttachmentContent(this.attachment, this.xwikiContext);
            this.xwikiContext.getWiki().saveDocument(dDoc, this.xwikiContext);
            return;
        }
        catch (XWikiException e) {
            throw new DavException(500, (Throwable)e);
        }
    }

    public void copy(DavResource destination, boolean shallow) throws DavException {
        throw new DavException(501);
    }

    public MultiStatusResponse alterProperties(DavPropertySet setProperties, DavPropertyNameSet removePropertyNames) throws DavException {
        throw new DavException(501);
    }

    public MultiStatusResponse alterProperties(List changeList) throws DavException {
        throw new DavException(501);
    }

    public void removeProperty(DavPropertyName propertyName) throws DavException {
        throw new DavException(501);
    }

    public void setProperty(DavProperty property) throws DavException {
        throw new DavException(501);
    }

    public long getModificationTime() {
        if (this.exists()) {
            return this.attachment.getDate().getTime();
        }
        return -1L;
    }

    public String getSupportedMethods() {
        return "OPTIONS, GET, HEAD, PROPFIND, PROPPATCH, COPY, DELETE, MOVE, LOCK, UNLOCK";
    }
}

