/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.resources.views;

import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.partial.AbstractDavView;
import java.util.ArrayList;
import java.util.Stack;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Composable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootView
extends AbstractDavView
implements Composable {
    private static final Logger LOG = LoggerFactory.getLogger(RootView.class);
    private ComponentManager componentManager;

    public void compose(ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    public XWikiDavResource decode(DavResourceLocator locator) throws DavException {
        String workspacePath = locator.getWorkspacePath();
        if (workspacePath == null) {
            return this;
        }
        if (workspacePath.equals("/webdav")) {
            Stack<XWikiDavResource> stack = new Stack<XWikiDavResource>();
            stack.push(this);
            this.decode(stack, locator.getResourcePath().split("/"), 2);
            return stack.pop();
        }
        throw new DavException(400);
    }

    @Override
    public void decode(Stack<XWikiDavResource> stack, String[] tokens, int next) throws DavException {
        if (next < tokens.length) {
            String nextToken = tokens[next];
            XWikiDavResource resource = null;
            try {
                resource = (XWikiDavResource)this.componentManager.lookup(ROLE, nextToken + "-baseview");
                resource.init(this, nextToken, "/" + nextToken);
                stack.push(resource);
                resource.decode(stack, tokens, next + 1);
            }
            catch (ComponentLookupException e) {
                throw new DavException(500, (Throwable)e);
            }
        }
    }

    public DavResourceIterator getMembers() {
        ArrayList<XWikiDavResource> children = new ArrayList<XWikiDavResource>();
        try {
            XWikiDavResource homeView = (XWikiDavResource)this.componentManager.lookup(ROLE, "home-baseview");
            homeView.init(this, "home", "/home");
            children.add(homeView);
            XWikiDavResource pagesView = (XWikiDavResource)this.componentManager.lookup(ROLE, "pages-baseview");
            pagesView.init(this, "pages", "/pages");
            children.add(pagesView);
            XWikiDavResource attachmentsView = (XWikiDavResource)this.componentManager.lookup(ROLE, "attachments-baseview");
            attachmentsView.init(this, "attachments", "/attachments");
            children.add(attachmentsView);
            XWikiDavResource orphansView = (XWikiDavResource)this.componentManager.lookup(ROLE, "orphans-baseview");
            orphansView.init(this, "orphans", "/orphans");
            children.add(orphansView);
            XWikiDavResource whatsnewView = (XWikiDavResource)this.componentManager.lookup(ROLE, "whatsnew-baseview");
            whatsnewView.init(this, "whatsnew", "/whatsnew");
            children.add(whatsnewView);
        }
        catch (ComponentLookupException e) {
            LOG.error("Unexpected Error : ", (Throwable)e);
        }
        catch (DavException e) {
            LOG.error("Unexpected Error : ", (Throwable)e);
        }
        return new DavResourceIteratorImpl(children);
    }

    public void addMember(DavResource resource, InputContext inputContext) throws DavException {
        throw new DavException(405);
    }

    public void removeMember(DavResource member) throws DavException {
        throw new DavException(405);
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getSupportedMethods() {
        return "OPTIONS, GET, HEAD, PROPFIND, LOCK, UNLOCK";
    }
}

