/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.resources.views.pages;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.domain.DavPage;
import com.xpn.xwiki.plugin.webdav.resources.partial.AbstractDavView;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagesByFirstLettersSubView
extends AbstractDavView {
    private static final Logger LOG = LoggerFactory.getLogger(PagesByFirstLettersSubView.class);

    @Override
    public void init(XWikiDavResource parent, String name, String relativePath) throws DavException {
        super.init(parent, name, relativePath);
        if (!(name.startsWith("_") && name.endsWith("_") && name.equals(name.toUpperCase()))) {
            throw new DavException(500);
        }
    }

    @Override
    public void decode(Stack<XWikiDavResource> stack, String[] tokens, int next) throws DavException {
        String spaceName = this.getCollection().getDisplayName();
        if (next < tokens.length) {
            String docName = tokens[next];
            DavPage page = new DavPage();
            page.init(this, spaceName + "." + docName, "/" + docName);
            stack.push(page);
            page.decode(stack, tokens, next + 1);
        }
    }

    public DavResourceIterator getMembers() {
        ArrayList<DavPage> children = new ArrayList<DavPage>();
        String spaceName = this.getCollection().getDisplayName();
        String filter = this.getDisplayName().substring("_".length(), this.getDisplayName().length() - "_".length());
        try {
            List docNames = this.xwikiContext.getWiki().getStore().searchDocumentsNames("where doc.web='" + spaceName + "'", 0, 0, this.xwikiContext);
            for (String docName : docNames) {
                int dot;
                String pageName;
                if (!this.xwikiContext.getWiki().getRightService().hasAccessLevel("view", this.xwikiContext.getUser(), docName, this.xwikiContext) || !(pageName = docName.substring((dot = docName.lastIndexOf(46)) + 1)).toUpperCase().startsWith(filter)) continue;
                DavPage page = new DavPage();
                page.init(this, docName, "/" + pageName);
                children.add(page);
            }
        }
        catch (XWikiException e) {
            LOG.error("Unexpected Error : ", (Throwable)e);
        }
        catch (DavException e) {
            LOG.error("Unexpected Error : ", (Throwable)e);
        }
        return new DavResourceIteratorImpl(children);
    }

    public void addMember(DavResource resource, InputContext inputContext) throws DavException {
        throw new DavException(405);
    }

    public void removeMember(DavResource member) throws DavException {
        throw new DavException(405);
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getSupportedMethods() {
        return "OPTIONS, GET, HEAD, PROPFIND, LOCK, UNLOCK";
    }
}

