/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.resources.views.pages;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.domain.DavPage;
import com.xpn.xwiki.plugin.webdav.resources.partial.AbstractDavView;
import com.xpn.xwiki.plugin.webdav.resources.views.pages.PagesByFirstLettersSubView;
import com.xpn.xwiki.plugin.webdav.utils.XWikiDavUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagesBySpaceNameSubView
extends AbstractDavView {
    private static final Logger LOG = LoggerFactory.getLogger(PagesBySpaceNameSubView.class);

    @Override
    public void decode(Stack<XWikiDavResource> stack, String[] tokens, int next) throws DavException {
        if (next < tokens.length) {
            String token = tokens[next];
            if (token.startsWith("_") && token.endsWith("_")) {
                PagesByFirstLettersSubView subView = new PagesByFirstLettersSubView();
                subView.init(this, token.toUpperCase(), "/" + token.toUpperCase());
                stack.push(subView);
                subView.decode(stack, tokens, next + 1);
            } else {
                DavPage page = new DavPage();
                page.init(this, this.name + "." + token, "/" + token);
                stack.push(page);
                page.decode(stack, tokens, next + 1);
            }
        }
    }

    @Override
    public boolean exists() {
        try {
            List spaces = this.xwikiContext.getWiki().getSpaces(this.xwikiContext);
            if (spaces.contains(this.name)) {
                return true;
            }
        }
        catch (XWikiException e) {
            LOG.error("Unexpected Error : ", (Throwable)e);
        }
        return false;
    }

    public DavResourceIterator getMembers() {
        ArrayList<PagesByFirstLettersSubView> children = new ArrayList<PagesByFirstLettersSubView>();
        try {
            List docNames = this.xwikiContext.getWiki().getStore().searchDocumentsNames("where doc.web='" + this.name + "'", 0, 0, this.xwikiContext);
            HashSet<String> subViewNames = new HashSet<String>();
            int subViewNameLength = XWikiDavUtils.getSubViewNameLength(docNames.size());
            for (String docName : docNames) {
                int dot;
                String pageName = docName.substring((dot = docName.lastIndexOf(46)) + 1);
                if (subViewNameLength < pageName.length()) {
                    subViewNames.add(pageName.substring(0, subViewNameLength).toUpperCase());
                    continue;
                }
                subViewNames.add(pageName.toUpperCase());
            }
            for (String subViewName : subViewNames) {
                try {
                    String modName = "_" + subViewName + "_";
                    PagesByFirstLettersSubView subView = new PagesByFirstLettersSubView();
                    subView.init(this, modName, "/" + modName);
                    children.add(subView);
                }
                catch (DavException e) {
                    LOG.error("Unexpected Error : ", (Throwable)e);
                }
            }
        }
        catch (XWikiException e) {
            LOG.error("Unexpected Error : ", (Throwable)e);
        }
        return new DavResourceIteratorImpl(children);
    }

    public void addMember(DavResource resource, InputContext inputContext) throws DavException {
        if (resource instanceof DavPage) {
            String pName = ((DavPage)resource).getDisplayName();
            try {
                XWikiDocument childDoc = this.xwikiContext.getWiki().getDocument(pName, this.xwikiContext);
                childDoc.setContent("This page was created thorugh xwiki-webdav interface.");
                this.xwikiContext.getWiki().saveDocument(childDoc, this.xwikiContext);
            }
            catch (XWikiException e) {
                throw new DavException(500, (Throwable)e);
            }
        } else {
            throw new DavException(400);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeMember(DavResource member) throws DavException {
        if (!(member instanceof DavPage)) throw new DavException(400);
        String pName = ((DavPage)member).getDisplayName();
        try {
            XWikiDocument childDoc = this.xwikiContext.getWiki().getDocument(pName, this.xwikiContext);
            if (childDoc.isNew()) return;
            this.xwikiContext.getWiki().deleteDocument(childDoc, this.xwikiContext);
            return;
        }
        catch (XWikiException e) {
            throw new DavException(500, (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void move(DavResource destination) throws DavException {
        if (!(destination instanceof PagesBySpaceNameSubView)) throw new DavException(400);
        PagesBySpaceNameSubView dSpace = (PagesBySpaceNameSubView)destination;
        if (dSpace.exists()) throw new DavException(400);
        if (!this.getCollection().equals(dSpace.getCollection())) throw new DavException(400);
        try {
            List docNames = this.xwikiContext.getWiki().getStore().searchDocumentsNames("where doc.web='" + this.name + "'", 0, 0, this.xwikiContext);
            for (String docName : docNames) {
                XWikiDocument doc = this.xwikiContext.getWiki().getDocument(docName, this.xwikiContext);
                String newDocName = dSpace.getDisplayName() + "." + doc.getName();
                doc.rename(newDocName, this.xwikiContext);
            }
            return;
        }
        catch (XWikiException e) {
            throw new DavException(500, (Throwable)e);
        }
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getSupportedMethods() {
        return "OPTIONS, GET, HEAD, POST, PROPFIND, PROPPATCH, MKCOL, COPY, PUT, DELETE, MOVE, LOCK, UNLOCK";
    }
}

