/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.utils;

import com.xpn.xwiki.plugin.webdav.utils.XWikiDavSession;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.DavSessionProvider;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XWikiDavSessionProvider
implements DavSessionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(XWikiDavSessionProvider.class);

    public boolean attachSession(WebdavRequest request) throws DavException {
        String workspaceName = request.getRequestLocator().getWorkspaceName();
        if (workspaceName != null && "".equals(workspaceName)) {
            workspaceName = null;
        }
        XWikiDavSession ds = new XWikiDavSession();
        LOG.debug("Attaching session '" + ds + "' to request '" + request + "'");
        request.setDavSession((DavSession)ds);
        return true;
    }

    public void releaseSession(WebdavRequest request) {
        DavSession ds = request.getDavSession();
        if (ds != null && ds instanceof XWikiDavSession) {
            String[] lockTokens;
            XWikiDavSession session = (XWikiDavSession)ds;
            for (String token : lockTokens = session.getLockTokens()) {
                session.removeLockToken(token);
            }
            LOG.debug("Releasing session '" + ds + "' from request '" + request + "'");
        }
        request.setDavSession(null);
    }
}

