/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.resources.domain;

import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.domain.DavPage;
import com.xpn.xwiki.plugin.webdav.resources.partial.AbstractDavFile;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;

public class DavAttachment
extends AbstractDavFile {
    private XWikiAttachment attachment;

    public void init(XWikiDavResource parent, String name, String relativePath) throws DavException {
        super.init(parent, name, relativePath);
        if (parent.exists()) {
            this.attachment = ((DavPage)parent).getDocument().getAttachment(this.name);
        }
        if (this.exists()) {
            String timeStamp = DavConstants.creationDateFormat.format(this.attachment.getDate());
            this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.CREATIONDATE, (Object)timeStamp));
            timeStamp = DavConstants.modificationDateFormat.format(this.attachment.getDate());
            this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.GETLASTMODIFIED, (Object)timeStamp));
            this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.GETETAG, (Object)timeStamp));
            this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTTYPE, (Object)this.getContext().getMimeType(this.attachment)));
            this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLANGUAGE, (Object)this.attachment.getDoc().getLanguage()));
            this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLENGTH, (Object)this.attachment.getFilesize()));
        }
    }

    public boolean exists() {
        return this.attachment != null;
    }

    public void spool(OutputContext outputContext) throws IOException {
        OutputStream out;
        if (!this.getContext().hasAccess("view", this.attachment.getDoc().getFullName())) {
            throw new IOException("Access rights violation.");
        }
        outputContext.setContentLanguage(this.attachment.getDoc().getLanguage());
        outputContext.setContentLength((long)this.attachment.getFilesize());
        outputContext.setContentType(this.getContext().getMimeType(this.attachment));
        outputContext.setETag(DavConstants.modificationDateFormat.format(this.getModificationTime()));
        outputContext.setModificationTime(this.getModificationTime());
        if (this.exists() && null != (out = outputContext.getOutputStream())) {
            try {
                out.write(this.getContext().getContent(this.attachment));
                out.flush();
            }
            catch (DavException ex) {
                throw new IOException(ex.getMessage());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void move(DavResource destination) throws DavException {
        this.getContext().checkAccess("edit", this.attachment.getDoc().getFullName());
        if (!(destination instanceof DavAttachment)) throw new DavException(400);
        DavAttachment dAttachment = (DavAttachment)destination;
        if (dAttachment.getCollection().equals(this.getCollection())) {
            this.getContext().moveAttachment(this.attachment, this.attachment.getDoc(), dAttachment.getDisplayName());
        } else {
            if (!(dAttachment.getCollection() instanceof DavPage)) throw new DavException(400);
            XWikiDocument dDoc = ((DavPage)dAttachment.getCollection()).getDocument();
            this.getContext().moveAttachment(this.attachment, dDoc, dAttachment.getDisplayName());
        }
        this.clearCache();
    }

    public long getModificationTime() {
        if (this.exists()) {
            return this.attachment.getDate().getTime();
        }
        return -1L;
    }
}

