/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.resources.views.pages;

import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.domain.DavPage;
import com.xpn.xwiki.plugin.webdav.resources.domain.DavTempFile;
import com.xpn.xwiki.plugin.webdav.resources.partial.AbstractDavView;
import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagesByFirstLettersSubView
extends AbstractDavView {
    private static final Logger logger = LoggerFactory.getLogger(PagesByFirstLettersSubView.class);

    public void init(XWikiDavResource parent, String name, String relativePath) throws DavException {
        super.init(parent, name, relativePath);
        if (!(name.startsWith("_") && name.endsWith("_") && name.equals(name.toUpperCase()))) {
            throw new DavException(500);
        }
    }

    public XWikiDavResource decode(String[] tokens, int next) throws DavException {
        String spaceName = this.getCollection().getDisplayName();
        boolean last = next == tokens.length - 1;
        String nextToken = tokens[next];
        if (this.isTempResource(nextToken)) {
            return super.decode(tokens, next);
        }
        if (!last || !this.getContext().isCreateFileRequest()) {
            DavPage page = new DavPage();
            page.init(this, spaceName + "." + nextToken, "/" + nextToken);
            return last ? page : page.decode(tokens, next + 1);
        }
        throw new DavException(400);
    }

    public DavResourceIterator getMembers() {
        ArrayList<XWikiDavResource> children = new ArrayList<XWikiDavResource>();
        String spaceName = this.getCollection().getDisplayName();
        String filter = this.getDisplayName().substring("_".length(), this.getDisplayName().length() - "_".length());
        try {
            String sql = "where doc.web='" + spaceName + "'";
            List<String> docNames = this.getContext().searchDocumentsNames(sql);
            for (String docName : docNames) {
                int dot;
                String pageName;
                if (!this.getContext().hasAccess("view", docName) || !(pageName = docName.substring((dot = docName.lastIndexOf(46)) + 1)).toUpperCase().startsWith(filter)) continue;
                DavPage page = new DavPage();
                page.init(this, docName, "/" + pageName);
                children.add(page);
            }
        }
        catch (DavException e) {
            logger.error("Unexpected Error : ", (Throwable)e);
        }
        children.addAll(this.getVirtualMembers());
        return new DavResourceIteratorImpl(children);
    }

    public void addMember(DavResource resource, InputContext inputContext) throws DavException {
        if (resource instanceof DavTempFile) {
            this.addVirtualMember(resource, inputContext);
        } else {
            this.getCollection().addMember(resource, inputContext);
        }
    }

    public void removeMember(DavResource member) throws DavException {
        if (member instanceof DavTempFile) {
            this.removeVirtualMember(member);
        } else {
            this.getCollection().removeMember(member);
        }
    }
}

