/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.Pack;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.panels.ShortcutData;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.MultiLineLabel;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.TargetFactory;
import com.izforge.izpack.util.VariableSubstitutor;
import com.izforge.izpack.util.os.Shortcut;
import com.izforge.izpack.util.os.unix.UnixHelper;
import com.izforge.izpack.util.xml.XMLHelper;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLBuilder;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;

public class ShortcutPanel
extends IzPanel
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 3256722870838112311L;
    public static final String SPEC_ATTRIBUTE_KDE_USERNAME = "KdeUsername";
    public static final String SPEC_ATTRIBUTE_KDE_SUBST_UID = "KdeSubstUID";
    public static final String SPEC_ATTRIBUTE_URL = "url";
    public static final String SPEC_ATTRIBUTE_TYPE = "type";
    public static final String SPEC_ATTRIBUTE_TERMINAL_OPTIONS = "terminalOptions";
    public static final String SPEC_ATTRIBUTE_TERMINAL = "terminal";
    public static final String SPEC_ATTRIBUTE_MIMETYPE = "mimetype";
    public static final String SPEC_ATTRIBUTE_ENCODING = "encoding";
    private static final String LOCATION_APPLICATIONS = "applications";
    private static final String LOCATION_START_MENU = "startMenu";
    public static final String SPEC_CATEGORIES = "categories";
    public static final String SPEC_TRYEXEC = "tryexec";
    private static final String SEPARATOR_LINE = "--------------------------------------------------------------------------------";
    private static final String TEXT_FILE_NAME = "Shortcuts.txt";
    private static final String SPEC_FILE_NAME = "shortcutSpec.xml";
    private static final String SPEC_KEY_SKIP_IFNOT_SUPPORTED = "skipIfNotSupported";
    private static final String SPEC_KEY_NOT_SUPPORTED = "notSupported";
    private static final String SPEC_KEY_PROGRAM_GROUP = "programGroup";
    private static final String SPEC_KEY_SHORTCUT = "shortcut";
    private static final String SPEC_KEY_PACKS = "createForPack";
    private static final String SPEC_ATTRIBUTE_DEFAULT_GROUP = "defaultName";
    private static final String SPEC_ATTRIBUTE_INSTALLGROUP = "installGroup";
    private static final String SPEC_ATTRIBUTE_LOCATION = "location";
    private static final String SPEC_ATTRIBUTE_NAME = "name";
    private static final String SPEC_ATTRIBUTE_SUBGROUP = "subgroup";
    private static final String SPEC_ATTRIBUTE_DESCRIPTION = "description";
    private static final String SPEC_ATTRIBUTE_TARGET = "target";
    private static final String SPEC_ATTRIBUTE_COMMAND = "commandLine";
    private static final String SPEC_ATTRIBUTE_ICON = "iconFile";
    private static final String SPEC_ATTRIBUTE_ICON_INDEX = "iconIndex";
    private static final String SPEC_ATTRIBUTE_WORKING_DIR = "workingDirectory";
    private static final String SPEC_ATTRIBUTE_INITIAL_STATE = "initialState";
    private static final String SPEC_ATTRIBUTE_DESKTOP = "desktop";
    private static final String SPEC_ATTRIBUTE_APPLICATIONS = "applications";
    private static final String SPEC_ATTRIBUTE_START_MENU = "startMenu";
    private static final String SPEC_ATTRIBUTE_STARTUP = "startup";
    private static final String SPEC_ATTRIBUTE_PROGRAM_GROUP = "programGroup";
    private static final String SPEC_VALUE_APPLICATIONS = "applications";
    private static final String SPEC_VALUE_START_MENU = "startMenu";
    private static final String SPEC_VALUE_NO_SHOW = "noShow";
    private static final String SPEC_VALUE_NORMAL = "normal";
    private static final String SPEC_VALUE_MAXIMIZED = "maximized";
    private static final String SPEC_VALUE_MINIMIZED = "minimized";
    public static final String AUTO_KEY_PROGRAM_GROUP = "programGroup";
    public static final String AUTO_KEY_SHORTCUT = "shortcut";
    public static final String AUTO_ATTRIBUTE_NAME = "name";
    public static final String AUTO_ATTRIBUTE_GROUP = "group";
    public static final String AUTO_ATTRIBUTE_TYPE = "type";
    public static final String AUTO_ATTRIBUTE_COMMAND = "commandLine";
    public static final String AUTO_ATTRIBUTE_DESCRIPTION = "description";
    public static final String AUTO_ATTRIBUTE_ICON = "icon";
    public static final String AUTO_ATTRIBUTE_ICON_INDEX = "iconIndex";
    public static final String AUTO_ATTRIBUTE_INITIAL_STATE = "initialState";
    public static final String AUTO_ATTRIBUTE_TARGET = "target";
    public static final String AUTO_ATTRIBUTE_WORKING_DIR = "workingDirectory";
    public static final String CREATE_FOR_ALL = "createForAll";
    private static ShortcutPanel self = null;
    static boolean create;
    public static boolean createImmediately;
    private static boolean isRootUser;
    private Vector execFiles = new Vector();
    private JLabel listLabel;
    private JList groupList;
    private JList targetList;
    private JTextField programGroup;
    private JButton defaultButton;
    private JButton saveButton;
    private JCheckBox allowDesktopShortcut;
    private JCheckBox createShortcuts;
    private JRadioButton currentUser;
    private JRadioButton allUsers;
    private GridBagLayout layout;
    private GridBagConstraints constraints;
    private String suggestedProgramGroup;
    private String groupName;
    private int groupLocation;
    private XMLElement spec;
    private boolean hasDesktopShortcuts = false;
    private boolean skipIfNotSupported = false;
    private Shortcut shortcut;
    private Vector shortcuts = new Vector();
    private Vector files = new Vector();
    private boolean shortcutsToCreate = false;
    private boolean haveShortcutSpec = false;
    private boolean simulteNotSupported = false;
    private File itsProgramFolder;
    private int itsUserType;
    public static final String USER_TYPE = "usertype";
    private Vector shortCuts;
    int line;
    int col;

    public ShortcutPanel(InstallerFrame parent, InstallData installData) {
        super(parent, installData, "link16x16");
        this.layout = (GridBagLayout)super.getLayout();
        Object con = this.getLayoutHelper().getDefaultConstraints();
        if (con instanceof GridBagConstraints) {
            this.constraints = (GridBagConstraints)con;
        } else {
            con = new GridBagConstraints();
        }
        this.setLayout(super.getLayout());
        if (self != null) {
            throw new RuntimeException(this.getClass().getName() + " is not allowed to instantiate more than once!");
        }
        self = this;
    }

    public void actionPerformed(ActionEvent event) {
        Object eventSource = event.getSource();
        if (eventSource.equals(this.currentUser)) {
            this.groupList.setListData(this.shortcut.getProgramGroups(1));
            this.programGroup.setText(this.suggestedProgramGroup);
            this.itsUserType = 1;
            this.shortcut.setUserType(1);
            return;
        }
        if (eventSource.equals(this.allUsers)) {
            this.groupList.setListData(this.shortcut.getProgramGroups(2));
            this.programGroup.setText(this.suggestedProgramGroup);
            this.itsUserType = 2;
            this.shortcut.setUserType(2);
            return;
        }
        if (eventSource.equals(this.defaultButton)) {
            this.groupList.getSelectionModel().clearSelection();
            this.programGroup.setText(this.suggestedProgramGroup);
            return;
        }
        if (eventSource.equals(this.saveButton)) {
            this.saveToFile();
            this.addToUninstaller();
            return;
        }
        if (eventSource.equals(this.createShortcuts)) {
            create = this.createShortcuts.isSelected();
            if (this.groupList != null) {
                this.groupList.setEnabled(create);
            }
            this.programGroup.setEnabled(create);
            this.currentUser.setEnabled(create);
            this.defaultButton.setEnabled(create);
            if (this.allowDesktopShortcut != null) {
                this.allowDesktopShortcut.setEnabled(create);
            }
            if (isRootUser) {
                this.allUsers.setEnabled(create);
            }
        }
    }

    public boolean isValidated() {
        try {
            this.groupName = this.programGroup.getText();
        }
        catch (Throwable exception) {
            this.groupName = "";
        }
        create = this.createShortcuts.isSelected();
        if (createImmediately) {
            this.createAndRegisterShortcuts();
        }
        return true;
    }

    public void panelActivate() {
        try {
            this.readShortcutSpec();
        }
        catch (Throwable exception) {
            System.out.println("could not read shortcut spec!");
            exception.printStackTrace();
        }
        try {
            this.shortcut = (Shortcut)TargetFactory.getInstance().makeObject("com.izforge.izpack.util.os.Shortcut");
            this.shortcut.initialize(1, "-");
        }
        catch (Throwable exception) {
            System.out.println("could not create shortcut instance");
            exception.printStackTrace();
        }
        this.analyzeShortcutSpec();
        if (this.shortcutsToCreate && !OsVersion.IS_OSX) {
            if (this.shortcut.supported() && !this.simulteNotSupported) {
                File allUsersProgramsFolder = this.getProgramsFolder(2);
                Debug.log("All UsersProgramsFolder: '" + allUsersProgramsFolder + "'");
                File forceTest = new File(allUsersProgramsFolder + File.separator + System.getProperty("user.name") + System.currentTimeMillis());
                try {
                    isRootUser = forceTest.createNewFile();
                }
                catch (Exception e) {
                    isRootUser = false;
                    Debug.log("IOException: '" + e.getLocalizedMessage() + "'");
                    Debug.log("You cannot create '" + forceTest + "'");
                }
                if (forceTest.exists()) {
                    Debug.log("Delete temporary File: '" + forceTest + "'");
                    forceTest.delete();
                }
                String perm = isRootUser ? "can" : "cannot";
                Debug.log("You " + perm + " write into '" + allUsersProgramsFolder + "'");
                this.itsUserType = isRootUser ? 2 : 1;
                this.buildUI(this.getProgramsFolder(isRootUser ? 2 : 1));
            } else {
                this.buildAlternateUI();
            }
        } else {
            this.parent.skipPanel();
        }
    }

    private File getProgramsFolder(int userType) {
        String path = this.shortcut.getProgramsFolder(userType);
        return new File(path);
    }

    public void valueChanged(ListSelectionEvent event) {
        if (this.programGroup == null) {
            return;
        }
        String value = "";
        try {
            value = (String)this.groupList.getSelectedValue();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (value == null) {
            value = "";
        }
        this.programGroup.setText(value + File.separator + this.suggestedProgramGroup);
    }

    private void readShortcutSpec() throws Exception {
        InputStream input = null;
        try {
            input = this.parent.getResource(TargetFactory.getCurrentOSPrefix() + SPEC_FILE_NAME);
        }
        catch (ResourceNotFoundException rnfE) {
            input = this.parent.getResource(SPEC_FILE_NAME);
        }
        if (input == null) {
            this.haveShortcutSpec = false;
            return;
        }
        VariableSubstitutor substitutor = new VariableSubstitutor(this.idata.getVariables());
        String substitutedSpec = substitutor.substitute(input, "xml");
        StdXMLParser parser = new StdXMLParser();
        parser.setBuilder(new StdXMLBuilder());
        parser.setValidator(new NonValidator());
        parser.setReader(StdXMLReader.stringReader(substitutedSpec));
        this.spec = (XMLElement)parser.parse();
        input.close();
        this.haveShortcutSpec = true;
    }

    private void analyzeShortcutSpec() {
        if (!this.haveShortcutSpec) {
            this.shortcutsToCreate = false;
            return;
        }
        XMLElement skipper = this.spec.getFirstChildNamed(SPEC_KEY_SKIP_IFNOT_SUPPORTED);
        this.skipIfNotSupported = skipper != null;
        XMLElement support = this.spec.getFirstChildNamed(SPEC_KEY_NOT_SUPPORTED);
        if (support != null) {
            this.simulteNotSupported = true;
        }
        XMLElement group = null;
        Vector groupSpecs = this.spec.getChildrenNamed("programGroup");
        String selectedInstallGroup = this.idata.getVariable("INSTALL_GROUP");
        if (selectedInstallGroup != null) {
            for (int i = 0; i < groupSpecs.size(); ++i) {
                XMLElement g = (XMLElement)groupSpecs.get(i);
                String instGrp = g.getAttribute(SPEC_ATTRIBUTE_INSTALLGROUP);
                if (instGrp == null || !selectedInstallGroup.equalsIgnoreCase(instGrp)) continue;
                group = g;
                break;
            }
        }
        if (group == null) {
            group = this.spec.getFirstChildNamed("programGroup");
        }
        String location = null;
        this.hasDesktopShortcuts = false;
        if (group != null) {
            this.suggestedProgramGroup = group.getAttribute(SPEC_ATTRIBUTE_DEFAULT_GROUP, "");
            location = group.getAttribute(SPEC_ATTRIBUTE_LOCATION, "applications");
        } else {
            this.suggestedProgramGroup = "";
            location = "applications";
        }
        if (location.equals("applications")) {
            this.groupLocation = 1;
        } else if (location.equals("startMenu")) {
            this.groupLocation = 2;
        }
        Vector shortcutSpecs = this.spec.getChildrenNamed("shortcut");
        this.shortCuts = new Vector();
        for (int i = 0; i < shortcutSpecs.size(); ++i) {
            Vector forPacks;
            XMLElement shortcutSpec = (XMLElement)shortcutSpecs.elementAt(i);
            if (!OsConstraint.oneMatchesCurrentSystem(shortcutSpec) || !this.checkConditions(shortcutSpec)) continue;
            ShortcutData data = new ShortcutData();
            data.name = shortcutSpec.getAttribute("name");
            data.subgroup = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_SUBGROUP, "");
            data.description = shortcutSpec.getAttribute("description", "");
            data.deskTopEntryLinux_Encoding = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_ENCODING, "");
            data.deskTopEntryLinux_MimeType = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_MIMETYPE, "");
            data.deskTopEntryLinux_Terminal = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_TERMINAL, "");
            data.deskTopEntryLinux_TerminalOptions = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_TERMINAL_OPTIONS, "");
            data.deskTopEntryLinux_Type = shortcutSpec.getAttribute("type", "");
            data.deskTopEntryLinux_URL = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_URL, "");
            data.deskTopEntryLinux_X_KDE_SubstituteUID = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_KDE_SUBST_UID, "false");
            data.deskTopEntryLinux_X_KDE_UserName = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_KDE_USERNAME, "root");
            data.Categories = shortcutSpec.getAttribute(SPEC_CATEGORIES, "Application;Development");
            data.TryExec = shortcutSpec.getAttribute(SPEC_TRYEXEC, "");
            data.createForAll = new Boolean(shortcutSpec.getAttribute(CREATE_FOR_ALL, "false"));
            data.target = this.fixSeparatorChar(shortcutSpec.getAttribute("target", ""));
            data.commandLine = shortcutSpec.getAttribute("commandLine", "");
            data.iconFile = this.fixSeparatorChar(shortcutSpec.getAttribute(SPEC_ATTRIBUTE_ICON, ""));
            data.iconIndex = Integer.parseInt(shortcutSpec.getAttribute("iconIndex", "0"));
            data.workingDirectory = this.fixSeparatorChar(shortcutSpec.getAttribute("workingDirectory", ""));
            String initialState = shortcutSpec.getAttribute("initialState", "");
            data.initialState = initialState.equals(SPEC_VALUE_NO_SHOW) ? 0 : (initialState.equals(SPEC_VALUE_NORMAL) ? 1 : (initialState.equals(SPEC_VALUE_MAXIMIZED) ? 3 : (initialState.equals(SPEC_VALUE_MINIMIZED) ? 2 : 1)));
            if (data.name == null) continue;
            if (data.target == null) {
                data.target = "";
            }
            if (!this.shortcutRequiredFor(forPacks = shortcutSpec.getChildrenNamed(SPEC_KEY_PACKS))) continue;
            if (XMLHelper.attributeIsTrue(shortcutSpec, SPEC_ATTRIBUTE_DESKTOP)) {
                this.hasDesktopShortcuts = true;
                data.addToGroup = false;
                data.type = 3;
                this.shortcuts.add(data.clone());
            }
            if (XMLHelper.attributeIsTrue(shortcutSpec, "applications")) {
                data.addToGroup = false;
                data.type = 1;
                this.shortcuts.add(data.clone());
            }
            if (XMLHelper.attributeIsTrue(shortcutSpec, "startMenu")) {
                data.addToGroup = false;
                data.type = 2;
                this.shortcuts.add(data.clone());
            }
            if (XMLHelper.attributeIsTrue(shortcutSpec, SPEC_ATTRIBUTE_STARTUP)) {
                data.addToGroup = false;
                data.type = 4;
                this.shortcuts.add(data.clone());
            }
            if (XMLHelper.attributeIsTrue(shortcutSpec, "programGroup")) {
                data.addToGroup = true;
                data.type = 1;
                this.shortcuts.add(data.clone());
            }
            this.shortCuts.add(data.name == null ? "" : data.name);
        }
        if (this.shortcuts.size() > 0) {
            this.shortcutsToCreate = true;
        }
    }

    private boolean checkConditions(XMLElement shortcutSpec) {
        return true;
    }

    public void createAndRegisterShortcuts() {
        this.createShortcuts();
        this.addToUninstaller();
    }

    private String createGnomeMenu(Vector shortcuts, String menuName) {
        String menuConfigText = "<Menu>\n<Name>Applications</Name>\n<Menu>\n<Name>" + menuName + "</Name>\n" + "<Include>\n";
        for (int i = 0; i < shortcuts.size(); ++i) {
            ShortcutData data = (ShortcutData)shortcuts.elementAt(i);
            menuConfigText = menuConfigText + "<Filename>" + data.name + ".desktop</Filename>\n";
        }
        menuConfigText = menuConfigText + "</Include>\n</Menu>\n</Menu>";
        return menuConfigText;
    }

    private void createShortcuts() {
        if (!create) {
            Debug.log(this.getClass().getName() + "::createShortcuts():create=" + create);
            return;
        }
        String gn = this.groupName;
        if (OsVersion.IS_UNIX) {
            String menuFile = this.createGnomeMenu(this.shortcuts, this.groupName);
            String menuFolder = System.getProperty("user.home") + File.separator + ".config/menus/applications-merged/";
            File menuConfigFolder = new File(menuFolder);
            String menuFilePath = menuFolder + this.groupName + ".menu";
            menuConfigFolder.mkdirs();
            boolean failed = false;
            try {
                FileWriter menuFileWriter = new FileWriter(menuFilePath);
                menuFileWriter.write(menuFile);
                menuFileWriter.close();
            }
            catch (Exception ignore) {
                failed = true;
                Debug.log("Failed to create menu for gnome.");
            }
            if (!failed) {
                UninstallData.getInstance().addFile(menuFilePath);
            }
        }
        for (int i = 0; i < this.shortcuts.size(); ++i) {
            ShortcutData data = (ShortcutData)this.shortcuts.elementAt(i);
            try {
                gn = this.groupName + data.subgroup;
                this.shortcut.setUserType(this.itsUserType);
                this.shortcut.setLinkName(data.name);
                this.shortcut.setLinkType(data.type);
                this.shortcut.setArguments(data.commandLine);
                this.shortcut.setDescription(data.description);
                this.shortcut.setIconLocation(data.iconFile, data.iconIndex);
                this.shortcut.setShowCommand(data.initialState);
                this.shortcut.setTargetPath(data.target);
                this.shortcut.setWorkingDirectory(data.workingDirectory);
                this.shortcut.setEncoding(data.deskTopEntryLinux_Encoding);
                this.shortcut.setMimetype(data.deskTopEntryLinux_MimeType);
                this.shortcut.setTerminal(data.deskTopEntryLinux_Terminal);
                this.shortcut.setTerminalOptions(data.deskTopEntryLinux_TerminalOptions);
                this.shortcut.setType(data.deskTopEntryLinux_Type);
                this.shortcut.setKdeSubstUID(data.deskTopEntryLinux_X_KDE_SubstituteUID);
                this.shortcut.setKdeUserName(data.deskTopEntryLinux_X_KDE_UserName);
                this.shortcut.setURL(data.deskTopEntryLinux_URL);
                this.shortcut.setTryExec(data.TryExec);
                this.shortcut.setCategories(data.Categories);
                this.shortcut.setCreateForAll(data.createForAll);
                this.shortcut.setUninstaller(UninstallData.getInstance());
                if (data.addToGroup) {
                    this.shortcut.setProgramGroup(gn);
                } else {
                    this.shortcut.setProgramGroup("");
                }
                try {
                    if (data.type == 3 && (data.type != 3 || !this.allowDesktopShortcut.isSelected())) continue;
                    this.shortcut.save();
                    String fileName = this.shortcut.getFileName();
                    this.files.add(0, fileName);
                    File file = new File(fileName);
                    File base = new File(this.shortcut.getBasePath());
                    Vector<File> intermediates = new Vector<File>();
                    this.execFiles.add(new ExecutableFile(fileName, 2, 3, new ArrayList(), false));
                    this.files.add(fileName);
                    while ((file = file.getParentFile()) != null && !file.equals(base)) {
                        intermediates.add(file);
                    }
                    if (file == null) continue;
                    Enumeration filesEnum = intermediates.elements();
                    while (filesEnum.hasMoreElements()) {
                        this.files.add(0, filesEnum.nextElement().toString());
                    }
                    continue;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            catch (Throwable exception) {
                // empty catch block
            }
        }
        this.shortcut.execPostAction();
        try {
            if (this.execFiles != null) {
                FileExecutor executor = new FileExecutor(this.execFiles);
            }
        }
        catch (NullPointerException nep) {
            nep.printStackTrace();
        }
        catch (RuntimeException cannot) {
            cannot.printStackTrace();
        }
        this.shortcut.cleanUp();
    }

    private boolean shortcutRequiredFor(Vector packs) {
        if (packs.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.idata.selectedPacks.size(); ++i) {
            String selected = ((Pack)this.idata.selectedPacks.get((int)i)).name;
            for (int k = 0; k < packs.size(); ++k) {
                String required = ((XMLElement)packs.elementAt(k)).getAttribute("name", "");
                if (!selected.equals(required)) continue;
                return true;
            }
        }
        return false;
    }

    private String fixSeparatorChar(String path) {
        String newPath = path.replace('/', File.separatorChar);
        newPath = newPath.replace('\\', File.separatorChar);
        return newPath;
    }

    private void buildUI(File groups) {
        this.constraints.insets = new Insets(10, 10, 0, 0);
        String menuKind = this.parent.langpack.getString("ShortcutPanel.regular.StartMenu:Start-Menu");
        if (OsVersion.IS_UNIX && UnixHelper.kdeIsInstalled()) {
            menuKind = this.parent.langpack.getString("ShortcutPanel.regular.StartMenu:K-Menu");
        }
        this.createShortcuts = new JCheckBox(StringTool.replace(this.parent.langpack.getString("ShortcutPanel.regular.create"), "StartMenu", menuKind), true);
        this.createShortcuts.addActionListener(this);
        this.constraints.gridx = this.col;
        this.constraints.gridy = this.line + 1;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.fill = 2;
        this.constraints.anchor = 18;
        this.layout.addLayoutComponent(this.createShortcuts, this.constraints);
        this.add(this.createShortcuts);
        this.constraints.insets = new Insets(0, 10, 0, 0);
        if (this.hasDesktopShortcuts) {
            String initialAllowedValue = this.idata.getVariable("DesktopShortcutCheckboxEnabled");
            boolean initialAllowedFlag = false;
            if (initialAllowedValue == null) {
                initialAllowedFlag = false;
            } else if (Boolean.TRUE.toString().equals(initialAllowedValue)) {
                initialAllowedFlag = true;
            }
            this.allowDesktopShortcut = new JCheckBox(this.parent.langpack.getString("ShortcutPanel.regular.desktop"), initialAllowedFlag);
            this.constraints.gridx = this.col;
            this.constraints.gridy = this.line + 2;
            this.constraints.gridwidth = 1;
            this.constraints.gridheight = 1;
            this.layout.addLayoutComponent(this.allowDesktopShortcut, this.constraints);
            this.add(this.allowDesktopShortcut);
        }
        this.listLabel = LabelFactory.create(this.parent.langpack.getString("ShortcutPanel.regular.list"), 10);
        this.constraints.gridx = this.col;
        this.constraints.gridy = this.line + 3;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.insets = new Insets(10, 10, 0, 0);
        this.constraints.fill = 2;
        this.constraints.anchor = 18;
        this.layout.addLayoutComponent(this.listLabel, this.constraints);
        this.add(this.listLabel);
        Vector<String> dirEntries = new Vector<String>();
        File[] entries = groups.listFiles();
        if (entries != null) {
            for (int idx = 0; idx < entries.length; ++idx) {
                if (!entries[idx].isDirectory()) continue;
                dirEntries.add(entries[idx].getName());
            }
        }
        if (this.groupList == null) {
            this.groupList = new JList();
        }
        this.groupList = this.addList(dirEntries, 0, this.groupList, this.col, this.line + 4, 1, 1, 1);
        if (this.shortcut.multipleUsers()) {
            JPanel usersPanel = new JPanel(new GridLayout(2, 1));
            ButtonGroup usersGroup = new ButtonGroup();
            this.currentUser = new JRadioButton(this.parent.langpack.getString("ShortcutPanel.regular.currentUser"), !isRootUser);
            this.currentUser.addActionListener(this);
            usersGroup.add(this.currentUser);
            usersPanel.add(this.currentUser);
            this.allUsers = new JRadioButton(this.parent.langpack.getString("ShortcutPanel.regular.allUsers"), isRootUser);
            Debug.log("allUsers.setEnabled(), I'm Root: " + isRootUser);
            this.allUsers.setEnabled(isRootUser);
            this.allUsers.addActionListener(this);
            usersGroup.add(this.allUsers);
            usersPanel.add(this.allUsers);
            TitledBorder border = new TitledBorder(new EmptyBorder(2, 2, 2, 2), this.parent.langpack.getString("ShortcutPanel.regular.userIntro"));
            usersPanel.setBorder(border);
            this.constraints.gridx = this.col + 1;
            this.constraints.gridy = this.line + 4;
            this.constraints.gridwidth = 1;
            this.constraints.gridheight = 1;
            this.constraints.fill = 2;
            this.layout.addLayoutComponent(usersPanel, this.constraints);
            this.add(usersPanel);
        }
        this.programGroup = new JTextField(this.suggestedProgramGroup, 40);
        this.constraints.gridx = this.col;
        this.constraints.gridy = this.line + 5;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.fill = 2;
        this.layout.addLayoutComponent(this.programGroup, this.constraints);
        this.add(this.programGroup);
        this.defaultButton = ButtonFactory.createButton(this.parent.langpack.getString("ShortcutPanel.regular.default"), this.idata.buttonsHColor);
        this.defaultButton.addActionListener(this);
        this.constraints.gridx = this.col + 1;
        this.constraints.gridy = this.line + 5;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.fill = 2;
        this.layout.addLayoutComponent(this.defaultButton, this.constraints);
        this.add(this.defaultButton);
    }

    private JList addList(Vector Entries, int ListModel2, JList aJList, int aGridx, int aGridy, int aGridwidth, int aGridheight, int aFill) {
        if (aJList == null) {
            aJList = new JList(Entries);
        } else {
            aJList.setListData(Entries);
        }
        aJList.setSelectionMode(ListModel2);
        aJList.getSelectionModel().addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(aJList);
        this.constraints.gridx = aGridx;
        this.constraints.gridy = aGridy;
        this.constraints.gridwidth = aGridwidth;
        this.constraints.gridheight = aGridheight;
        this.constraints.weightx = 2.0;
        this.constraints.weighty = 1.5;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.constraints.fill = aFill;
        this.layout.addLayoutComponent(scrollPane, this.constraints);
        this.add(scrollPane);
        return aJList;
    }

    private void buildAlternateUI() {
        this.layout = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.setLayout(this.layout);
        MultiLineLabel apologyLabel = new MultiLineLabel(this.parent.langpack.getString("ShortcutPanel.alternate.apology"), 0, 0);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.layout.addLayoutComponent(apologyLabel, this.constraints);
        this.add(apologyLabel);
        MultiLineLabel listLabel = new MultiLineLabel(this.parent.langpack.getString("ShortcutPanel.alternate.targetsLabel"), 0, 0);
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.layout.addLayoutComponent(listLabel, this.constraints);
        this.add(listLabel);
        Vector<String> targets = new Vector<String>();
        for (int i = 0; i < this.shortcuts.size(); ++i) {
            targets.add(((ShortcutData)this.shortcuts.elementAt((int)i)).target);
        }
        this.targetList = new JList(targets);
        JScrollPane scrollPane = new JScrollPane(this.targetList);
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.constraints.fill = 1;
        this.layout.addLayoutComponent(scrollPane, this.constraints);
        this.add(scrollPane);
        MultiLineLabel fileExplanation = new MultiLineLabel(this.parent.langpack.getString("ShortcutPanel.alternate.textFileExplanation"), 0, 0);
        this.constraints.gridx = 0;
        this.constraints.gridy = 3;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.fill = 2;
        this.layout.addLayoutComponent(fileExplanation, this.constraints);
        this.add(fileExplanation);
        this.saveButton = ButtonFactory.createButton(this.parent.langpack.getString("ShortcutPanel.alternate.saveButton"), this.idata.buttonsHColor);
        this.saveButton.addActionListener(this);
        this.constraints.gridx = 0;
        this.constraints.gridy = 4;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.layout.addLayoutComponent(this.saveButton, this.constraints);
        this.add(this.saveButton);
    }

    public Dimension getSize() {
        Dimension size = this.getParent().getSize();
        Insets insets = this.getInsets();
        Border border = this.getBorder();
        Insets borderInsets = new Insets(0, 0, 0, 0);
        if (border != null) {
            borderInsets = border.getBorderInsets(this);
        }
        size.height = size.height - insets.top - insets.bottom - borderInsets.top - borderInsets.bottom - 50;
        size.width = size.width - insets.left - insets.right - borderInsets.left - borderInsets.right - 50;
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile() {
        File file = null;
        JFileChooser fileDialog = new JFileChooser(this.idata.getInstallPath());
        fileDialog.setSelectedFile(new File(TEXT_FILE_NAME));
        if (fileDialog.showSaveDialog(this) != 0) {
            return;
        }
        file = fileDialog.getSelectedFile();
        FileWriter output = null;
        StringBuffer buffer = new StringBuffer();
        String header = this.parent.langpack.getString("ShortcutPanel.textFile.header");
        String newline = System.getProperty("line.separator", "\n");
        try {
            output = new FileWriter(file);
        }
        catch (Throwable exception) {
            return;
        }
        int nextIndex = 0;
        int currentIndex = 0;
        do {
            if ((nextIndex = header.indexOf("\\n", currentIndex)) > -1) {
                buffer.append(header.substring(currentIndex, nextIndex));
                buffer.append(newline);
                currentIndex = nextIndex + 2;
                continue;
            }
            buffer.append(header.substring(currentIndex, header.length()));
            buffer.append(newline);
        } while (nextIndex > -1);
        buffer.append(SEPARATOR_LINE);
        buffer.append(newline);
        buffer.append(newline);
        for (int i = 0; i < this.shortcuts.size(); ++i) {
            ShortcutData data = (ShortcutData)this.shortcuts.elementAt(i);
            buffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.name"));
            buffer.append(data.name);
            buffer.append(newline);
            buffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.location"));
            switch (data.type) {
                case 3: {
                    buffer.append(this.parent.langpack.getString("ShortcutPanel.location.desktop"));
                    break;
                }
                case 1: {
                    buffer.append(this.parent.langpack.getString("ShortcutPanel.location.applications"));
                    break;
                }
                case 2: {
                    buffer.append(this.parent.langpack.getString("ShortcutPanel.location.startMenu"));
                    break;
                }
                case 4: {
                    buffer.append(this.parent.langpack.getString("ShortcutPanel.location.startup"));
                }
            }
            buffer.append(newline);
            buffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.description"));
            buffer.append(data.description);
            buffer.append(newline);
            buffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.target"));
            buffer.append(data.target);
            buffer.append(newline);
            buffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.command"));
            buffer.append(data.commandLine);
            buffer.append(newline);
            buffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.iconName"));
            buffer.append(data.iconFile);
            buffer.append(newline);
            buffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.iconIndex"));
            buffer.append(data.iconIndex);
            buffer.append(newline);
            buffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.work"));
            buffer.append(data.workingDirectory);
            buffer.append(newline);
            buffer.append(newline);
            buffer.append(SEPARATOR_LINE);
            buffer.append(newline);
            buffer.append(newline);
        }
        try {
            output.write(buffer.toString());
        }
        catch (Throwable exception) {
        }
        finally {
            try {
                output.flush();
                output.close();
                this.files.add(file.getPath());
            }
            catch (Throwable exception) {}
        }
    }

    private void addToUninstaller() {
        UninstallData uninstallData = UninstallData.getInstance();
        for (int i = 0; i < this.files.size(); ++i) {
            uninstallData.addFile((String)this.files.elementAt(i));
        }
    }

    public static ShortcutPanel getInstance() {
        return self;
    }

    public void makeXMLData(XMLElement panelRoot) {
        Debug.log("entering makeXMLData");
        if (!this.shortcutsToCreate || !this.shortcut.supported() || this.groupName == null || this.simulteNotSupported || !create) {
            Debug.log("abort makeXMLData!");
            return;
        }
        XMLElement dataElement = new XMLElement("programGroup");
        dataElement.setAttribute("name", this.groupName);
        panelRoot.addChild(dataElement);
        for (int i = 0; i < this.shortcuts.size(); ++i) {
            Debug.log("entering makeXMLData");
            ShortcutData data = (ShortcutData)this.shortcuts.elementAt(i);
            dataElement = new XMLElement("shortcut");
            dataElement.setAttribute("name", data.name);
            dataElement.setAttribute(AUTO_ATTRIBUTE_GROUP, (data.addToGroup ? Boolean.TRUE : Boolean.FALSE).toString());
            if (OsVersion.IS_WINDOWS) {
                dataElement.setAttribute("type", Integer.toString(data.type));
            }
            dataElement.setAttribute("commandLine", data.commandLine);
            dataElement.setAttribute("description", data.description);
            dataElement.setAttribute(AUTO_ATTRIBUTE_ICON, data.iconFile);
            dataElement.setAttribute("iconIndex", Integer.toString(data.iconIndex));
            dataElement.setAttribute("initialState", Integer.toString(data.initialState));
            dataElement.setAttribute("target", data.target);
            dataElement.setAttribute("workingDirectory", data.workingDirectory);
            dataElement.setAttribute(SPEC_ATTRIBUTE_ENCODING, data.deskTopEntryLinux_Encoding);
            dataElement.setAttribute(SPEC_ATTRIBUTE_MIMETYPE, data.deskTopEntryLinux_MimeType);
            dataElement.setAttribute(SPEC_ATTRIBUTE_TERMINAL, data.deskTopEntryLinux_Terminal);
            dataElement.setAttribute(SPEC_ATTRIBUTE_TERMINAL_OPTIONS, data.deskTopEntryLinux_TerminalOptions);
            if (!OsVersion.IS_WINDOWS) {
                dataElement.setAttribute("type", data.deskTopEntryLinux_Type);
            }
            dataElement.setAttribute(SPEC_ATTRIBUTE_URL, data.deskTopEntryLinux_URL);
            dataElement.setAttribute(SPEC_ATTRIBUTE_KDE_SUBST_UID, data.deskTopEntryLinux_X_KDE_SubstituteUID);
            dataElement.setAttribute(SPEC_CATEGORIES, data.Categories);
            dataElement.setAttribute(SPEC_TRYEXEC, data.TryExec);
            dataElement.setAttribute(CREATE_FOR_ALL, data.createForAll.toString());
            dataElement.setAttribute(USER_TYPE, Integer.toString(data.userType));
            if (data.type == 3 && (data.type != 3 || !this.allowDesktopShortcut.isSelected())) continue;
            panelRoot.addChild(dataElement);
        }
    }

    static {
        createImmediately = true;
    }
}

