/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.coi.tools.os.win.NativeLibException;
import com.izforge.izpack.Pack;
import com.izforge.izpack.event.NativeInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.Unpacker;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.SpecHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import com.izforge.izpack.util.os.RegistryDefaultHandler;
import com.izforge.izpack.util.os.RegistryHandler;
import com.izforge.izpack.util.os.WrappedNativeLibException;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import net.n3.nanoxml.XMLElement;

public class RegistryInstallerListener
extends NativeInstallerListener {
    private static final String SPEC_FILE_NAME = "RegistrySpec.xml";
    private static final String REG_KEY = "key";
    private static final String REG_VALUE = "value";
    private static final String REG_ROOT = "root";
    private static final String REG_BASENAME = "name";
    private static final String REG_KEYPATH = "keypath";
    private static final String REG_DWORD = "dword";
    private static final String REG_STRING = "string";
    private static final String REG_MULTI = "multi";
    private static final String REG_BIN = "bin";
    private static final String REG_DATA = "data";
    private static final String REG_OVERRIDE = "override";

    public RegistryInstallerListener() {
        super(true);
    }

    public void beforePacks(AutomatedInstallData automatedInstallData, Integer n, AbstractUIProgressHandler abstractUIProgressHandler) throws Exception {
        super.beforePacks(automatedInstallData, n, abstractUIProgressHandler);
        this.initializeRegistryHandler(automatedInstallData);
    }

    public void afterPacks(AutomatedInstallData automatedInstallData, AbstractUIProgressHandler abstractUIProgressHandler) throws Exception {
        try {
            Object object;
            Object object2;
            RegistryHandler registryHandler = RegistryDefaultHandler.getInstance();
            if (registryHandler == null) {
                return;
            }
            XMLElement xMLElement = null;
            Unpacker.setDiscardInterrupt(true);
            registryHandler.activateLogging();
            if (this.getSpecHelper().getSpec() != null) {
                object2 = new VariableSubstitutor(automatedInstallData.getVariables());
                object = automatedInstallData.selectedPacks.iterator();
                xMLElement = this.getSpecHelper().getPackForName("UninstallStuff");
                this.performPack(xMLElement, (VariableSubstitutor)object2);
                while (object != null && object.hasNext()) {
                    XMLElement xMLElement2 = this.getSpecHelper().getPackForName(((Pack)object.next()).name);
                    this.performPack(xMLElement2, (VariableSubstitutor)object2);
                }
            }
            if ((object2 = automatedInstallData.getVariable("UninstallKeySuffix")) != null) {
                registryHandler.setUninstallName(registryHandler.getUninstallName() + " " + (String)object2);
            }
            if (xMLElement == null) {
                registryHandler.registerUninstallKey();
            }
            if ((object = registryHandler.getLoggingInfo()) != null) {
                UninstallData.getInstance().addAdditionalData("registryEntries", object);
            }
        }
        catch (Exception exception) {
            if (exception instanceof NativeLibException) {
                throw new WrappedNativeLibException(exception);
            }
            throw exception;
        }
    }

    private void performPack(XMLElement xMLElement, VariableSubstitutor variableSubstitutor) throws Exception {
        if (xMLElement == null) {
            return;
        }
        Vector vector = xMLElement.getChildren();
        if (vector == null) {
            return;
        }
        Iterator iterator = vector.iterator();
        while (iterator != null && iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            String string = xMLElement2.getName();
            if (string.equalsIgnoreCase(REG_KEY)) {
                this.performKeySetting(xMLElement2, variableSubstitutor);
                continue;
            }
            if (string.equalsIgnoreCase(REG_VALUE)) {
                this.performValueSetting(xMLElement2, variableSubstitutor);
                continue;
            }
            this.getSpecHelper().parseError(xMLElement2, "Non-valid type of entry; only 'key' and 'value' are allowed.");
        }
    }

    private void performValueSetting(XMLElement xMLElement, VariableSubstitutor variableSubstitutor) throws Exception {
        SpecHelper specHelper = this.getSpecHelper();
        String string = specHelper.getRequiredAttribute(xMLElement, REG_BASENAME);
        string = variableSubstitutor.substitute(string, null);
        String string2 = specHelper.getRequiredAttribute(xMLElement, REG_KEYPATH);
        string2 = variableSubstitutor.substitute(string2, null);
        String string3 = specHelper.getRequiredAttribute(xMLElement, REG_ROOT);
        int n = this.resolveRoot(xMLElement, string3, variableSubstitutor);
        RegistryHandler registryHandler = RegistryDefaultHandler.getInstance();
        if (registryHandler == null) {
            return;
        }
        registryHandler.setRoot(n);
        String string4 = xMLElement.getAttribute(REG_OVERRIDE, "true");
        if (!"true".equalsIgnoreCase(string4) && registryHandler.getValue(string2, string, null) != null) {
            return;
        }
        String string5 = xMLElement.getAttribute(REG_DWORD);
        if (string5 != null) {
            string5 = variableSubstitutor.substitute(string5, null);
            registryHandler.setValue(string2, string, Long.parseLong(string5));
            return;
        }
        string5 = xMLElement.getAttribute(REG_STRING);
        if (string5 != null) {
            string5 = variableSubstitutor.substitute(string5, null);
            registryHandler.setValue(string2, string, string5);
            return;
        }
        Vector<XMLElement> vector = xMLElement.getChildrenNamed(REG_MULTI);
        if (vector != null && !vector.isEmpty()) {
            Iterator<XMLElement> iterator = vector.iterator();
            String[] stringArray = new String[vector.size()];
            int n2 = 0;
            while (iterator.hasNext()) {
                XMLElement xMLElement2 = iterator.next();
                stringArray[n2] = specHelper.getRequiredAttribute(xMLElement2, REG_DATA);
                stringArray[n2] = variableSubstitutor.substitute(stringArray[n2], null);
                ++n2;
            }
            registryHandler.setValue(string2, string, stringArray);
            return;
        }
        vector = xMLElement.getChildrenNamed(REG_BIN);
        if (vector != null && !vector.isEmpty()) {
            Iterator<XMLElement> iterator = vector.iterator();
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (iterator.hasNext()) {
                XMLElement xMLElement3 = iterator.next();
                String string6 = specHelper.getRequiredAttribute(xMLElement3, REG_DATA);
                stringBuffer.append(string6);
                if (!string6.endsWith(",") && iterator.hasNext()) {
                    stringBuffer.append(",");
                }
                ++n3;
            }
            byte[] byArray = this.extractBytes(xMLElement, variableSubstitutor.substitute(stringBuffer.toString(), null));
            registryHandler.setValue(string2, string, byArray);
            return;
        }
        specHelper.parseError(xMLElement, "No data found.");
    }

    private byte[] extractBytes(XMLElement xMLElement, String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        byte[] byArray = new byte[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            byte by = 0;
            String string2 = stringTokenizer.nextToken().trim();
            try {
                int n2 = Integer.parseInt(string2, 16);
                if (n2 < 0 || n2 > 255) {
                    throw new NumberFormatException("Value out of range.");
                }
                if (n2 > 127) {
                    n2 -= 256;
                }
                by = (byte)n2;
            }
            catch (NumberFormatException numberFormatException) {
                this.getSpecHelper().parseError(xMLElement, "Bad entry for REG_BINARY; a byte should be written as 2 digit hexvalue followed by a ','.");
            }
            byArray[n++] = by;
        }
        return byArray;
    }

    private void performKeySetting(XMLElement xMLElement, VariableSubstitutor variableSubstitutor) throws Exception {
        String string = this.getSpecHelper().getRequiredAttribute(xMLElement, REG_KEYPATH);
        string = variableSubstitutor.substitute(string, null);
        String string2 = this.getSpecHelper().getRequiredAttribute(xMLElement, REG_ROOT);
        int n = this.resolveRoot(xMLElement, string2, variableSubstitutor);
        RegistryHandler registryHandler = RegistryDefaultHandler.getInstance();
        if (registryHandler == null) {
            return;
        }
        registryHandler.setRoot(n);
        if (!registryHandler.keyExist(string)) {
            registryHandler.createKey(string);
        }
    }

    private int resolveRoot(XMLElement xMLElement, String string, VariableSubstitutor variableSubstitutor) throws Exception {
        String string2 = variableSubstitutor.substitute(string, null);
        Integer n = RegistryHandler.ROOT_KEY_MAP.get(string2);
        if (n != null) {
            return n;
        }
        this.getSpecHelper().parseError(xMLElement, "Unknown value (" + string2 + ")for registry root.");
        return 0;
    }

    private void initializeRegistryHandler(AutomatedInstallData automatedInstallData) throws Exception {
        RegistryHandler registryHandler = RegistryDefaultHandler.getInstance();
        if (registryHandler == null) {
            return;
        }
        registryHandler.verify(automatedInstallData);
        this.getSpecHelper().readSpec(SPEC_FILE_NAME);
    }
}

