/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.OsVersion;
import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HTMLInfoPanel
extends IzPanel
implements HyperlinkListener {
    private static final long serialVersionUID = 3257008769514025270L;
    private JEditorPane textArea;

    public HTMLInfoPanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData, new IzPanelLayout());
        this.add((Component)LabelFactory.create(installerFrame.langpack.getString("InfoPanel.info"), installerFrame.icons.getImageIcon("edit"), 10), "nextLine");
        try {
            this.textArea = new JEditorPane();
            this.textArea.setContentType("text/html; charset=utf-8");
            this.textArea.setEditable(false);
            this.textArea.addHyperlinkListener(this);
            JScrollPane jScrollPane = new JScrollPane(this.textArea);
            this.textArea.setPage(this.loadHTMLInfoContent());
            this.add((Component)jScrollPane, "nextLine");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.getLayoutHelper().completeLayout();
    }

    private URL loadHTMLInfoContent() {
        String string = "HTMLInfoPanel.info";
        if (this.getMetadata() != null && this.getMetadata().getPanelid() != null) {
            try {
                String string2 = "HTMLInfoPanel." + this.getMetadata().getPanelid();
                String string3 = ResourceManager.getInstance().getTextResource(string2);
                if (string3 != null) {
                    return ResourceManager.getInstance().getURL(string3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return ResourceManager.getInstance().getURL(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public boolean isValidated() {
        return true;
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        block8: {
            try {
                if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) break block8;
                String string = hyperlinkEvent.getURL().toExternalForm();
                if (string.contains("HTMLInfoPanel.info#")) {
                    this.textArea.setPage(hyperlinkEvent.getURL());
                    break block8;
                }
                if (OsVersion.IS_OSX) {
                    Runtime.getRuntime().exec("open " + string);
                    break block8;
                }
                if (OsVersion.IS_UNIX) {
                    String[] stringArray;
                    for (String string2 : stringArray = new String[]{"htmlview QqzURL", "xdg-open QqzURL", "gnome-open QqzURL", "kfmclient openURL QqzURL", "call-browser QqzURL", "firefox QqzURL", "opera QqzURL", "konqueror QqzURL", "epiphany QqzURL", "mozilla QqzURL", "netscape QqzURL"}) {
                        try {
                            Runtime.getRuntime().exec(string2.replaceAll("QqzURL", string));
                            System.out.println("OK");
                            break block8;
                        }
                        catch (Exception exception) {
                            System.out.println(string2 + " NOT OK");
                        }
                    }
                    break block8;
                }
                Runtime.getRuntime().exec("cmd /C start " + string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void panelActivate() {
        try {
            this.textArea.setPage(this.loadHTMLInfoContent());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

