/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it;

import com.xpn.xwiki.it.framework.AbstractClusterHttpTest;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.xwiki.rest.model.jaxb.Attachment;
import org.xwiki.rest.model.jaxb.Attachments;
import org.xwiki.rest.resources.attachments.AttachmentResource;
import org.xwiki.rest.resources.attachments.AttachmentsResource;

public class DocumentCacheTest
extends AbstractClusterHttpTest {
    public void testDocumentCacheSync() throws Exception {
        this.switchXWiki(0);
        this.setPageContent(this.getWiki(), "Test", "CacheSync", "content");
        DocumentCacheTest.assertEquals((String)"content", (String)this.getPageContent(this.getWiki(), "Test", "CacheSync"));
        this.switchXWiki(1);
        this.setPageContent(this.getWiki(), "Test", "CacheSync", "modified content");
        DocumentCacheTest.assertEquals((String)"modified content", (String)this.getPageContent(this.getWiki(), "Test", "CacheSync"));
        this.switchXWiki(0);
        DocumentCacheTest.assertEquals((String)"modified content", (String)this.getPageContent(this.getWiki(), "Test", "CacheSync"));
    }

    public void testDocumentCacheSyncForAttachments() throws Exception {
        this.switchXWiki(0);
        this.setPageContent(this.getWiki(), "Test", "AttachementCacheSync", "content");
        this.switchXWiki(1);
        String attachmentUri = this.getUriBuilder(AttachmentResource.class).build(new Object[]{this.getWiki(), "Test", "AttachementCacheSync", "file.ext"}).toString();
        PutMethod putMethod = this.executePut(attachmentUri, "content", "text/plain", "Admin", "admin");
        DocumentCacheTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (int)201, (int)putMethod.getStatusCode());
        this.switchXWiki(0);
        String attachmentsUri = this.getUriBuilder(AttachmentsResource.class).build(new Object[]{this.getWiki(), "Test", "AttachementCacheSync"}).toString();
        GetMethod getMethod = this.executeGet(attachmentsUri);
        DocumentCacheTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        boolean found = false;
        Attachments attachments = (Attachments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        for (Attachment attachment : attachments.getAttachments()) {
            System.out.println(attachment.getName());
            if (!attachment.getName().equals("file.ext")) continue;
            found = true;
        }
        DocumentCacheTest.assertTrue((String)"Failed to find attachment", (boolean)found);
    }
}

