/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.escaping;

import java.io.IOException;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.xwiki.escaping.framework.AbstractEscapingTest;
import org.xwiki.escaping.framework.AbstractManualTest;
import org.xwiki.escaping.framework.XMLEscapingValidator;

public class ManualTemplateTest
extends AbstractManualTest {
    @BeforeClass
    public static void init() {
        AbstractEscapingTest.setMultiLanguageMode(true);
    }

    @AfterClass
    public static void shutdown() {
        AbstractEscapingTest.setMultiLanguageMode(false);
    }

    @Test
    public void testVersionSummary() {
        String space = "Test";
        String page = "TestVersionSummary";
        String url = ManualTemplateTest.createUrl("save", space, page, ManualTemplateTest.params(ManualTemplateTest.kv("title", "Test"), ManualTemplateTest.kv("content", "Test"), ManualTemplateTest.test("comment"), ManualTemplateTest.kv("action_save", "Save+%26+View")));
        AbstractEscapingTest.getUrlContent(url);
        this.deleteAfterwards(space, page);
        this.checkUnderEscaping(ManualTemplateTest.createUrl(null, space, page, ManualTemplateTest.params(new String[][]{ManualTemplateTest.kv("viewer", "history")})), "Version summary");
    }

    @Test
    public void testEditReflectedXSS() {
        this.skipIfIgnored("templates/htmlheader.vm");
        this.checkUnderEscaping(ManualTemplateTest.createUrl("edit", "Main", XMLEscapingValidator.getTestString(), null), "XWIKI-4758");
    }

    @Test
    public void testErrorTraceEscaping() {
        this.skipIfIgnored("templates/exceptioninline.vm");
        this.checkUnderEscaping(ManualTemplateTest.createUrl("viewrev", "Main", "WebHome", ManualTemplateTest.params(new String[][]{ManualTemplateTest.test("rev")})), "XWIKI-5170 error trace");
    }

    @Test
    public void testEditorEscaping() {
        this.skipIfIgnored("templates/edit.vm");
        this.checkUnderEscaping(ManualTemplateTest.createUrl("edit", "Main", "Page", ManualTemplateTest.params(new String[][]{ManualTemplateTest.test("editor")})), "XWIKI-5164 editor");
        this.checkUnderEscaping(ManualTemplateTest.createUrl("edit", "Main", "Page", ManualTemplateTest.params(ManualTemplateTest.kv("editor", "wysiwyg"), ManualTemplateTest.test("section"))), "XWIKI-5164 section");
        this.checkUnderEscaping(ManualTemplateTest.createUrl("edit", "Main", "Page", ManualTemplateTest.params(ManualTemplateTest.kv("editor", "wiki"), ManualTemplateTest.test("x-maximized"))), "XWIKI-5164 x-maximized");
    }

    @Test
    public void testAdminEditor() {
        this.skipIfIgnored("templates/admin.vm");
        this.checkUnderEscaping(ManualTemplateTest.createUrl("admin", "XWiki", "AdminSheet", ManualTemplateTest.params(new String[][]{ManualTemplateTest.test("editor")})), "XWIKI-5190 admin editor");
        this.checkUnderEscaping(ManualTemplateTest.createUrl("view", "Main", "WebHome", ManualTemplateTest.params(ManualTemplateTest.kv("xpage", "admin"), ManualTemplateTest.test("editor"))), "XWIKI-5190 admin editor redirect");
    }

    @Test
    public void testAdminSection() {
        this.skipIfIgnored("templates/admin.vm");
        this.checkUnderEscaping(ManualTemplateTest.createUrl("admin", "XWiki", "AdminSheet", ManualTemplateTest.params(new String[][]{ManualTemplateTest.test("section")})), "XWIKI-5190 admin section");
        this.checkUnderEscaping(ManualTemplateTest.createUrl("view", "Main", "WebHome", ManualTemplateTest.params(ManualTemplateTest.kv("xpage", "admin"), ManualTemplateTest.test("section"))), "XWIKI-5190 admin section redirect");
    }

    @Test
    public void testAttachmentsInline() {
        this.skipIfIgnored("templates/attachments*.vm");
        this.checkUnderEscaping(ManualTemplateTest.createUrl("view", "Sandbox", "WebHome", ManualTemplateTest.params(ManualTemplateTest.kv("viewer", "attachments"), ManualTemplateTest.test("xredirect"))), "XWIKI-5191 attachments inline");
    }

    @Test
    public void testBrowseWysiwygSQL() throws IOException {
        this.skipIfIgnored("templates/browsewysiwyg.vm");
        String url = ManualTemplateTest.createUrl("view", "Sandbox", "WebHome", ManualTemplateTest.params(ManualTemplateTest.kv("xpage", "browsewysiwyg"), ManualTemplateTest.test("text")));
        this.checkUnderEscaping(url, "XWIKI-5193 sql");
        this.checkForErrorTrace(url);
    }

    @Test
    public void testBrowseWysiwygPage() {
        this.skipIfIgnored("templates/browsewysiwyg.vm");
        this.createPage("Main", XMLEscapingValidator.getTestString(), XMLEscapingValidator.getTestString(), "Bla bla");
        this.checkUnderEscaping(ManualTemplateTest.createUrl("view", "Main", "Test", ManualTemplateTest.params(new String[][]{ManualTemplateTest.template("browsewysiwyg")})), "XWIKI-5193 page");
    }

    @Test
    public void testWysiwygRecentViewsPage() {
        this.skipIfIgnored("templates/recentdocwysiwyg.vm");
        this.createPage("Main", XMLEscapingValidator.getTestString(), XMLEscapingValidator.getTestString(), "Bla bla");
        this.checkUnderEscaping(ManualTemplateTest.createUrl("view", "Main", "Test", ManualTemplateTest.params(new String[][]{ManualTemplateTest.template("recentdocwysiwyg")})), "XWIKI-5193 recent docs");
    }

    @Test
    public void testSearchWysiwygSQL() throws IOException {
        this.skipIfIgnored("templates/searchwysiwyg.vm");
        String spaceUrl = ManualTemplateTest.createUrl("view", "Main", "Test", ManualTemplateTest.params(ManualTemplateTest.kv("xpage", "searchwysiwyg"), ManualTemplateTest.test("space")));
        this.checkUnderEscaping(spaceUrl, "XWIKI-5344 sql space");
        this.checkForErrorTrace(spaceUrl);
        String pageUrl = ManualTemplateTest.createUrl("view", "Main", "Test", ManualTemplateTest.params(ManualTemplateTest.kv("xpage", "searchwysiwyg"), ManualTemplateTest.test("page")));
        this.checkUnderEscaping(pageUrl, "XWIKI-5344 sql page");
        this.checkForErrorTrace(pageUrl);
    }

    @Test
    public void testSearchWysiwygPageLink() {
        this.skipIfIgnored("templates/searchwysiwyg.vm");
        this.createPage("Main", XMLEscapingValidator.getTestString(), XMLEscapingValidator.getTestString(), "Bla bla");
        this.checkUnderEscaping(ManualTemplateTest.createUrl("view", "Main", "Test", ManualTemplateTest.params(new String[][]{ManualTemplateTest.template("searchwysiwyg")})), "XWIKI-5344 page link");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoginRedirect() {
        this.skipIfIgnored("templates/login.vm");
        ManualTemplateTest.setLoggedIn(false);
        try {
            this.checkUnderEscaping(ManualTemplateTest.createUrl("login", "XWiki", "XWikiLogin", ManualTemplateTest.params(new String[][]{ManualTemplateTest.test("xredirect")})), "XWIKI-5246 xredirect");
        }
        finally {
            ManualTemplateTest.setLoggedIn(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoginSrid() {
        this.skipIfIgnored("templates/login.vm");
        ManualTemplateTest.setLoggedIn(false);
        try {
            this.checkUnderEscaping(ManualTemplateTest.createUrl("login", "XWiki", "XWikiLogin", ManualTemplateTest.params(new String[][]{ManualTemplateTest.test("srid")})), "XWIKI-5246 srid");
        }
        finally {
            ManualTemplateTest.setLoggedIn(true);
        }
    }

    @Test
    public void testEditActions() {
        this.skipIfIgnored("edit comment");
        this.createPage("Main", XMLEscapingValidator.getTestString(), XMLEscapingValidator.getTestString(), "Bla bla");
        this.checkUnderEscaping(ManualTemplateTest.createUrl("edit", "Main", "WebHome", ManualTemplateTest.params(ManualTemplateTest.kv("editor", "wiki"), ManualTemplateTest.test("comment"))), "edit comment");
    }

    @Test
    public void testCreateEditMode() {
        this.skipIfIgnored("templates/create.vm");
        this.checkUnderEscaping(ManualTemplateTest.createUrl("edit", "Main", XMLEscapingValidator.getTestString(), ManualTemplateTest.params(new String[][]{ManualTemplateTest.template("createinline")})), "XWIKI-5207 create inline");
        this.checkUnderEscaping(ManualTemplateTest.createUrl("edit", "Main", XMLEscapingValidator.getTestString(), ManualTemplateTest.params(ManualTemplateTest.template("create"), ManualTemplateTest.kv("ajax", "1"))), "XWIKI-5207 create ajax");
    }

    @Test
    public void testCopySourcedoc() {
        this.testCopy("sourcedoc");
    }

    @Test
    public void testCopyLanguage() {
        this.testCopy("language");
    }

    @Test
    public void testCopyExistingPage() {
        this.skipIfIgnored("templates/copy.vm");
        this.createPage("Main", XMLEscapingValidator.getTestString(), "", "Bla bla");
        this.checkUnderEscaping(ManualTemplateTest.createUrl("view", "Main", XMLEscapingValidator.getTestString(), ManualTemplateTest.params(new String[][]{ManualTemplateTest.kv("xpage", "copy")})), "XWIKI-5206 copy existing page");
    }

    private void testCopy(String parameter) {
        this.skipIfIgnored("templates/copy.vm");
        String url = ManualTemplateTest.createUrl(null, null, null, ManualTemplateTest.params(ManualTemplateTest.template("copy"), ManualTemplateTest.test("targetdoc"), ManualTemplateTest.test(parameter)));
        this.deleteAfterwards(null, XMLEscapingValidator.getTestString());
        this.checkUnderEscaping(url, "\"" + parameter + "\"");
    }

    @Test
    public void testRename() {
        this.skipIfIgnored("templates/rename.vm");
        String[] tested = new String[]{"language", "sourcedoc", "targetdoc", "newPageName", "newSpaceName", "parameterNames"};
        this.deleteAfterwards(null, XMLEscapingValidator.getTestString());
        for (String parameter : tested) {
            this.createPage(null, "testRenameSource" + System.nanoTime(), "test", "test");
            Map<String, String> params = ManualTemplateTest.params(ManualTemplateTest.template("rename"), ManualTemplateTest.kv("step", "2"), ManualTemplateTest.test(parameter));
            if (!params.containsKey("newPageName")) {
                String page = "testRename" + System.nanoTime();
                params.put("newPageName", page);
                this.deleteAfterwards(null, page);
            }
            String url = ManualTemplateTest.createUrl(null, null, null, params);
            this.checkUnderEscaping(url, "\"" + parameter + "\"");
        }
    }

    @Test
    public void testRenameExistingTarget() {
        this.skipIfIgnored("templates/rename.vm");
        String space = "Test";
        String page = "RenameTest";
        this.createPage(space, page, "Title", "Content");
        this.createPage(XMLEscapingValidator.getTestString(), XMLEscapingValidator.getTestString(), "Title", "Content");
        String url = ManualTemplateTest.createUrl(null, space, page, ManualTemplateTest.params(ManualTemplateTest.template("rename"), ManualTemplateTest.kv("step", "2"), ManualTemplateTest.test("newSpaceName"), ManualTemplateTest.test("newPageName")));
        this.checkUnderEscaping(url, "XWIKI-5442");
    }

    @Test
    public void testRenameSuccess() {
        this.skipIfIgnored("templates/rename.vm");
        String space = "Test";
        String page = "RenameTest";
        this.createPage(space, page, "Title", "Content");
        String testTarget = "Target" + XMLEscapingValidator.getTestString();
        testTarget = testTarget.replaceAll(">", "");
        this.deleteAfterwards(testTarget, testTarget);
        String url = ManualTemplateTest.createUrl(null, space, page, ManualTemplateTest.params(ManualTemplateTest.template("rename"), ManualTemplateTest.kv("step", "2"), ManualTemplateTest.kv("newSpaceName", testTarget), ManualTemplateTest.kv("newPageName", testTarget)));
        this.checkUnderEscaping(url, "XWIKI-5442");
    }

    @Test
    public void testDelete() {
        this.skipIfIgnored("templates/delete.vm");
        this.checkUnderEscaping(ManualTemplateTest.createUrl("view", null, null, ManualTemplateTest.params(ManualTemplateTest.template("delete"), ManualTemplateTest.kv("id", "bla"), ManualTemplateTest.test("xredirect"))), "XWIKI-5239");
    }

    @Test
    public void testDeleteVersionsConfirm() {
        this.skipIfIgnored("templates/deleteversionsconfirm.vm");
        this.checkUnderEscaping(ManualTemplateTest.createUrl("view", null, null, ManualTemplateTest.params(ManualTemplateTest.template("deleteversionsconfirm"), ManualTemplateTest.test("rev1"), ManualTemplateTest.test("rev2"))), "XWIKI-5238");
    }

    @Test
    public void testSuggestHibquery() throws IOException {
        this.skipIfIgnored("templates/suggest.vm");
        this.testSuggest("AnnotationCode.AnnotationConfig", "annotationClass", "Hibquery");
    }

    @Test
    public void testSuggestDBTree() throws IOException {
        this.skipIfIgnored("templates/suggest.vm");
        this.testSuggest("Blog.BlogPostClass", "category", "DBTree");
    }

    @Test
    public void testSuggestStaticList() throws IOException {
        this.skipIfIgnored("templates/suggest.vm");
        this.testSuggest("XWiki.ConfigurableClass", "propertiesToShow", "StaticList");
    }

    private void testSuggest(String classname, String fieldname, String description) throws IOException {
        String[] tested;
        for (String parameter : tested = new String[]{"firCol", "input"}) {
            String url = ManualTemplateTest.createUrl("view", "Main", null, ManualTemplateTest.params(ManualTemplateTest.template("suggest"), ManualTemplateTest.kv("classname", classname), ManualTemplateTest.kv("fieldname", fieldname), ManualTemplateTest.kv("secCol", "doc.fullName';"), ManualTemplateTest.test(parameter)));
            this.checkUnderEscaping(url, "XWIKI-5450: " + description + " (\"" + parameter + "\")");
            this.checkForErrorTrace(url);
        }
    }
}

