/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.escaping;

import java.util.Map;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.xwiki.escaping.framework.AbstractEscapingTest;
import org.xwiki.escaping.framework.AbstractManualTest;
import org.xwiki.escaping.framework.XMLEscapingValidator;

public class UsersAndGroupsTest
extends AbstractManualTest {
    private static final String TEST_USER = "User" + XMLEscapingValidator.getTestString();
    private static final String TEST_GROUP = "Group" + XMLEscapingValidator.getTestString();

    @BeforeClass
    public static void init() throws InterruptedException {
        AbstractEscapingTest.getUrlContent(UsersAndGroupsTest.createUrl("save", "XWiki", TEST_GROUP, UsersAndGroupsTest.params(new String[][]{UsersAndGroupsTest.kv("template", "XWiki.XWikiGroupTemplate")})));
        AbstractEscapingTest.getUrlContent(UsersAndGroupsTest.createUrl("register", "XWiki", "XWikiPreferences", UsersAndGroupsTest.params(UsersAndGroupsTest.template("registerinline"), UsersAndGroupsTest.kv("xwikiname", "TEST_USER"), UsersAndGroupsTest.test("register_first_name"), UsersAndGroupsTest.test("register_last_name"), UsersAndGroupsTest.kv("register_email", ""), UsersAndGroupsTest.test("register_password"), UsersAndGroupsTest.test("register2_password"), UsersAndGroupsTest.kv("template", "XWiki.XWikiUserTemplate"), UsersAndGroupsTest.kv("xredirect", ""))));
        AbstractEscapingTest.getUrlContent(UsersAndGroupsTest.createUrl("view", "XWiki", "TEST_USER", UsersAndGroupsTest.params(UsersAndGroupsTest.template("rename"), UsersAndGroupsTest.kv("step", "2"), UsersAndGroupsTest.kv("newSpaceName", "XWiki"), UsersAndGroupsTest.kv("newPageName", TEST_USER))));
        AbstractEscapingTest.getUrlContent(UsersAndGroupsTest.createUrl("view", "XWiki", TEST_GROUP, UsersAndGroupsTest.params(UsersAndGroupsTest.template("adduorg"), UsersAndGroupsTest.kv("uorg", "user"), UsersAndGroupsTest.kv("name", "XWiki." + TEST_USER))));
    }

    @AfterClass
    public static void shutdown() {
        AbstractEscapingTest.getUrlContent(UsersAndGroupsTest.createUrl("view", "XWiki", TEST_GROUP, UsersAndGroupsTest.params(UsersAndGroupsTest.template("deletegroupmember"), UsersAndGroupsTest.kv("fullname", "XWiki." + TEST_USER))));
        AbstractEscapingTest.getUrlContent(UsersAndGroupsTest.createUrl("admin", "XWiki", "XWikiPreferences", UsersAndGroupsTest.params(UsersAndGroupsTest.template("deleteuorg"), UsersAndGroupsTest.kv("docname", "XWiki." + TEST_USER))));
        AbstractEscapingTest.getUrlContent(UsersAndGroupsTest.createUrl("admin", "XWiki", "XWikiPreferences", UsersAndGroupsTest.params(UsersAndGroupsTest.template("deleteuorg"), UsersAndGroupsTest.kv("docname", "XWiki." + TEST_GROUP))));
    }

    @Test
    public void testGetUsers() {
        this.skipIfIgnored("templates/getusers.vm");
        Map<String, String> parameters = UsersAndGroupsTest.params(UsersAndGroupsTest.template("getusers"), UsersAndGroupsTest.test("offset"), UsersAndGroupsTest.test("limit"), UsersAndGroupsTest.test("wiki"), UsersAndGroupsTest.test("reqNo"), UsersAndGroupsTest.test("sort"), UsersAndGroupsTest.test("dir"));
        this.checkUnderEscaping(UsersAndGroupsTest.createUrl("view", null, null, parameters, false), "XWIKI-5244 (get users)");
    }

    @Test
    public void testGetGroups() {
        this.skipIfIgnored("templates/getgroups.vm");
        Map<String, String> parameters = UsersAndGroupsTest.params(UsersAndGroupsTest.template("getgroups"), UsersAndGroupsTest.test("offset"), UsersAndGroupsTest.test("limit"), UsersAndGroupsTest.test("wiki"), UsersAndGroupsTest.test("reqNo"), UsersAndGroupsTest.test("sort"), UsersAndGroupsTest.test("dir"));
        this.checkUnderEscaping(UsersAndGroupsTest.createUrl("view", null, null, parameters, false), "XWIKI-5244 (get groups)");
    }

    @Test
    public void testGetUsersAndGroups() {
        this.skipIfIgnored("templates/getusersandgroups.vm");
        Map<String, String> parameters = UsersAndGroupsTest.params(UsersAndGroupsTest.template("getusersandgroups"), UsersAndGroupsTest.test("offset"), UsersAndGroupsTest.test("limit"), UsersAndGroupsTest.test("wiki"), UsersAndGroupsTest.test("reqNo"), UsersAndGroupsTest.test("sort"), UsersAndGroupsTest.test("dir"), UsersAndGroupsTest.test("clsname"), UsersAndGroupsTest.test("space"), UsersAndGroupsTest.test("uorg"));
        this.checkUnderEscaping(UsersAndGroupsTest.createUrl("view", null, null, parameters, false), "XWIKI-5244 (get users and groups)");
    }

    @Test
    public void testGetUsersAndGroupsUsers() {
        this.skipIfIgnored("templates/getusersandgroups.vm");
        Map<String, String> parameters = UsersAndGroupsTest.params(UsersAndGroupsTest.template("getusersandgroups"), UsersAndGroupsTest.test("offset"), UsersAndGroupsTest.test("limit"), UsersAndGroupsTest.test("wiki"), UsersAndGroupsTest.test("reqNo"), UsersAndGroupsTest.test("sort"), UsersAndGroupsTest.test("dir"), UsersAndGroupsTest.test("clsname"), UsersAndGroupsTest.test("space"), UsersAndGroupsTest.kv("uorg", "users"));
        this.checkUnderEscaping(UsersAndGroupsTest.createUrl("view", null, null, parameters, false), "XWIKI-5244 (get users and groups: uorg=users)");
    }

    @Test
    public void testGetUsersAndGroupsGroups() {
        this.skipIfIgnored("templates/getusersandgroups.vm");
        Map<String, String> parameters = UsersAndGroupsTest.params(UsersAndGroupsTest.template("getusersandgroups"), UsersAndGroupsTest.test("offset"), UsersAndGroupsTest.test("limit"), UsersAndGroupsTest.test("wiki"), UsersAndGroupsTest.test("reqNo"), UsersAndGroupsTest.test("sort"), UsersAndGroupsTest.test("dir"), UsersAndGroupsTest.test("clsname"), UsersAndGroupsTest.test("space"), UsersAndGroupsTest.kv("uorg", "groups"));
        this.checkUnderEscaping(UsersAndGroupsTest.createUrl("view", null, null, parameters, false), "XWIKI-5244 (get users and groups: uorg=groups)");
    }
}

