/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.escaping.suite;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.junit.Test;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.xwiki.escaping.suite.FileTest;
import org.xwiki.escaping.suite.FileTestRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveSuite
extends ParentRunner<Runner> {
    private final List<Runner> runners;
    private final String archivePath;

    public ArchiveSuite(Class<?> klass, RunnerBuilder builder) throws InitializationError {
        super(klass);
        this.validateTestClass();
        this.archivePath = this.getArchiveFromAnnotation();
        this.runners = this.createRunners(this.archivePath);
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    protected Description describeChild(Runner child) {
        return child.getDescription();
    }

    protected void runChild(Runner child, RunNotifier notifier) {
        child.run(notifier);
    }

    protected String getName() {
        String fileName = this.archivePath;
        int idx = this.archivePath.lastIndexOf("/");
        if (idx >= 0 && idx < this.archivePath.length() - 2) {
            fileName = this.archivePath.substring(idx + 1);
        }
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + fileName + ")\n";
    }

    public void sort(Sorter sorter) {
        super.sort(new Sorter((Comparator)new Comparator<Description>(){

            @Override
            public int compare(Description o1, Description o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        }));
    }

    private List<Runner> createRunners(String archivePath) throws InitializationError {
        ArrayList<Runner> list = new ArrayList<Runner>();
        try {
            ZipFile archive = new ZipFile(archivePath);
            Enumeration<? extends ZipEntry> entries = archive.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                InputStreamReader reader = new InputStreamReader(archive.getInputStream(entry));
                this.addTest(list, entry.getName(), reader);
            }
            archive.close();
        }
        catch (IOException exception) {
            throw new InitializationError((Throwable)exception);
        }
        return list;
    }

    private void addTest(List<Runner> list, String name, Reader reader) throws InitializationError {
        try {
            Object result = this.getTestClass().getOnlyConstructor().newInstance(new Object[0]);
            if (result instanceof FileTest) {
                FileTest test = (FileTest)result;
                if (test.initialize(name, reader)) {
                    list.add((Runner)new FileTestRunner(test));
                }
                return;
            }
        }
        catch (Exception exception) {
            throw new InitializationError((Throwable)exception);
        }
        throw new InitializationError("Failed to initialize the test for \"" + name + "\"");
    }

    private void validateTestClass() throws InitializationError {
        TestClass test = this.getTestClass();
        ArrayList<Exception> errors = new ArrayList<Exception>();
        if (!FileTest.class.isAssignableFrom(test.getJavaClass())) {
            errors.add(new Exception("The test class " + test.getName() + " should implement FileTest"));
        }
        if (test.getOnlyConstructor().getParameterTypes().length != 0) {
            errors.add(new Exception("Constructor of " + test.getName() + " should have no parameters"));
        }
        this.validatePublicVoidNoArgMethods(Test.class, false, errors);
        if (errors.size() != 0) {
            throw new InitializationError(errors);
        }
    }

    private String getArchiveFromAnnotation() throws InitializationError {
        List getters;
        String path = null;
        ArchivePath classAnnotation = this.getTestClass().getJavaClass().getAnnotation(ArchivePath.class);
        if (classAnnotation != null) {
            path = classAnnotation.value();
        }
        if ((getters = this.getTestClass().getAnnotatedMethods(ArchivePathGetter.class)).size() > 1) {
            throw new InitializationError("Only one method should be annotated with @ArchivePathGetter. The test case \"" + this.getTestClass().getName() + "\" has " + getters.size() + " annotated methods.");
        }
        if (classAnnotation == null && getters.size() == 0) {
            throw new InitializationError("No archive path annotations found. The test case \"" + this.getTestClass().getName() + "\" should be annotated with @ArchivePath or @ArchivePathGetter");
        }
        if (getters.size() == 1) {
            path = this.invokeGetter(((FrameworkMethod)getters.get(0)).getMethod());
        }
        if (path == null) {
            throw new InitializationError("Archive path is null.");
        }
        return path;
    }

    protected Statement withBeforeClasses(Statement statement) {
        Statement result = super.withBeforeClasses(statement);
        List methods = this.getTestClass().getAnnotatedMethods(BeforeSuite.class);
        if (methods.isEmpty()) {
            return result;
        }
        return new RunBefores(result, methods, null);
    }

    protected Statement withAfterClasses(Statement statement) {
        Statement result = super.withAfterClasses(statement);
        List methods = this.getTestClass().getAnnotatedMethods(AfterSuite.class);
        if (methods.isEmpty()) {
            return result;
        }
        return new RunAfters(result, methods, null);
    }

    private String invokeGetter(Method getter) throws InitializationError {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        Class<?> getterClass = getter.getDeclaringClass();
        String getterName = getterClass.getName() + "." + getter.getName();
        if (!Modifier.isPublic(getterClass.getModifiers())) {
            errors.add(new Exception("The class " + getterClass.getName() + " should be public."));
        }
        if (!Modifier.isPublic(getter.getModifiers())) {
            errors.add(new Exception("The method " + getterName + " should be public."));
        }
        if (!Modifier.isStatic(getter.getModifiers())) {
            errors.add(new Exception("The method " + getterName + " should be static."));
        }
        if (!getter.getReturnType().equals(String.class)) {
            errors.add(new Exception("The method " + getterName + " should return String."));
        }
        if (getter.getParameterTypes().length != 0) {
            errors.add(new Exception("The method " + getterName + " should have no parameters."));
        }
        if (errors.size() != 0) {
            throw new InitializationError(errors);
        }
        try {
            Object result = getter.invoke(null, new Object[0]);
            if (result instanceof String) {
                return (String)result;
            }
        }
        catch (Exception exception) {
            throw new InitializationError((Throwable)exception);
        }
        return null;
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface AfterSuite {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface BeforeSuite {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface ArchivePathGetter {
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface ArchivePath {
        public String value();
    }
}

