/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiConfig;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.cache.api.XWikiCache;
import com.xpn.xwiki.cache.api.XWikiCacheNeedsRefreshException;
import com.xpn.xwiki.cache.api.XWikiCacheService;
import com.xpn.xwiki.cache.impl.OSCacheService;
import com.xpn.xwiki.it.framework.XWikiLDAPTestSetup;
import com.xpn.xwiki.plugin.ldap.XWikiLDAPConnection;
import com.xpn.xwiki.plugin.ldap.XWikiLDAPUtils;
import com.xpn.xwiki.web.XWikiEngineContext;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;

public class XWikiLDAPUtilsTest
extends TestCase {
    public static final String GROUPCACHE_NAME = "groups";
    private XWikiLDAPConnection connection = new XWikiLDAPConnection();
    private XWikiLDAPUtils ldapUtils = new XWikiLDAPUtils(this.connection);
    private XWikiContext context;
    static /* synthetic */ Class class$com$xpn$xwiki$cache$api$XWikiCacheNeedsRefreshException;

    public void setUp() throws Exception {
        this.context = new XWikiContext();
        new XWiki(new XWikiConfig(), this.context){
            private XWikiCacheService cacheService;

            public void initXWiki(XWikiConfig config, XWikiContext context, XWikiEngineContext enginecontext, boolean noupdate) throws XWikiException {
                context.setWiki((XWiki)this);
                this.setConfig(config);
            }

            public XWikiCacheService getCacheService() {
                if (this.cacheService == null) {
                    this.cacheService = new OSCacheService();
                    this.cacheService.init((XWiki)this);
                }
                return this.cacheService;
            }
        };
        this.ldapUtils.setUidAttributeName("uid");
        int port = XWikiLDAPTestSetup.getLDAPPort();
        this.connection.open("localhost", port, "cn=Horatio Hornblower,ou=people,o=sevenSeas", "pass", null, false);
    }

    public void testGetUidAttributeName() {
        Assert.assertSame((String)"Wrong uid attribute name", (Object)"uid", (Object)this.ldapUtils.getUidAttributeName());
    }

    public void testCache() throws XWikiException, XWikiCacheNeedsRefreshException, InterruptedException {
        XWikiCache tmpCache = this.ldapUtils.getCache(GROUPCACHE_NAME, this.context);
        XWikiCache cache = this.ldapUtils.getCache(GROUPCACHE_NAME, this.context);
        Assert.assertSame((String)"Cache is recreated", (Object)tmpCache, (Object)cache);
        cache.putInCache("key", (Object)"value");
        String value = (String)cache.getFromCache("key");
        Assert.assertEquals((String)"Value retrieved from cache is wrong", (String)"value", (String)value);
        Thread.sleep(1000L);
        try {
            value = (String)cache.getFromCache("key", 1);
            Assert.fail((String)("Should have thrown " + (class$com$xpn$xwiki$cache$api$XWikiCacheNeedsRefreshException == null ? (class$com$xpn$xwiki$cache$api$XWikiCacheNeedsRefreshException = XWikiLDAPUtilsTest.class$("com.xpn.xwiki.cache.api.XWikiCacheNeedsRefreshException")) : class$com$xpn$xwiki$cache$api$XWikiCacheNeedsRefreshException) + " exception because object has been added to the cache more than 1 second ago."));
        }
        catch (XWikiCacheNeedsRefreshException expected) {
            // empty catch block
        }
    }

    public void testGetGroupMembers() throws XWikiException {
        Map members = this.ldapUtils.getGroupMembers("cn=HMS Lydia,ou=crews,ou=groups,o=sevenSeas", this.context);
        Assert.assertFalse((String)"No member was found", (boolean)members.isEmpty());
        Assert.assertTrue((String)"Wrong members was found", (boolean)((Object)XWikiLDAPTestSetup.HMSLYDIA_MEMBERS).equals(members.keySet()));
        Map wrongGroupMembers = this.ldapUtils.getGroupMembers("wronggroupdn", this.context);
        Assert.assertNull((String)("Should return null if group does not exists [" + wrongGroupMembers + "]"), (Object)wrongGroupMembers);
    }

    public void testIsUserInGroup() throws XWikiException {
        String userDN = this.ldapUtils.isUserInGroup("hhornblo", "cn=HMS Lydia,ou=crews,ou=groups,o=sevenSeas", this.context);
        Assert.assertNotNull((String)"Users not found", (Object)userDN);
        Assert.assertEquals((String)"cn=Horatio Hornblower,ou=people,o=sevenSeas", (String)userDN);
        String wrongUserDN = this.ldapUtils.isUserInGroup("wronguseruid", "cn=HMS Lydia,ou=crews,ou=groups,o=sevenSeas", this.context);
        Assert.assertNull((String)"Should return null if user is not in the group", (Object)wrongUserDN);
    }

    public void tearDown() throws Exception {
        this.connection.close();
        super.tearDown();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

