/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.it.framework.AbstractLDAPTestCase;
import com.xpn.xwiki.it.framework.LDAPTestSetup;
import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.store.XWikiStoreInterface;
import com.xpn.xwiki.user.api.XWikiGroupService;
import com.xpn.xwiki.user.impl.LDAP.XWikiLDAPAuthServiceImpl;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.jmock.Mock;
import org.jmock.core.Invocation;
import org.jmock.core.Stub;
import org.jmock.core.stub.CustomStub;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheFactory;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.internal.DefaultCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWikiLDAPAuthServiceImplTest
extends AbstractLDAPTestCase {
    private static final String MAIN_WIKI_NAME = "xwiki";
    private static final String USER_XCLASS = "XWiki.XWikiUsers";
    private static final String GROUP_XCLASS = "XWiki.XWikiGroups";
    private XWikiLDAPAuthServiceImpl ldapAuth = new XWikiLDAPAuthServiceImpl();
    private CacheFactory cacheFactory = new CacheFactory(){

        public <T> Cache<T> newCache(CacheConfiguration config) throws CacheException {
            return new DefaultCache();
        }
    };
    private Properties properties = new Properties();
    private boolean isVirtualMode = false;
    private Map<String, Map<String, XWikiDocument>> databases = new HashMap<String, Map<String, XWikiDocument>>();
    private BaseClass userClass = new BaseClass();
    private BaseClass groupClass = new BaseClass();
    private Mock mockStore;
    private Mock mockGroupService;

    private Map<String, XWikiDocument> getDocuments(String database, boolean create) throws XWikiException {
        if (database == null) {
            database = this.getContext().getDatabase();
        }
        if (database == null || database.length() == 0) {
            database = MAIN_WIKI_NAME;
        }
        if (!this.databases.containsKey(database)) {
            if (create) {
                this.databases.put(database, new HashMap());
            } else {
                throw new XWikiException(3, 0, "Database " + database + " does not exists.");
            }
        }
        return this.databases.get(database);
    }

    private XWikiDocument getDocument(String documentFullName) throws XWikiException {
        XWikiDocument document = new XWikiDocument();
        document.setFullName(documentFullName);
        Map<String, XWikiDocument> docs = this.getDocuments(document.getDatabase(), false);
        if (docs.containsKey(document.getFullName())) {
            return docs.get(document.getFullName());
        }
        return document;
    }

    private void saveDocument(XWikiDocument document) throws XWikiException {
        document.setNew(false);
        Map<String, XWikiDocument> database = this.getDocuments(document.getDatabase(), true);
        database.remove(document.getFullName());
        database.put(document.getFullName(), document);
    }

    private boolean documentExists(String documentFullName) throws XWikiException {
        return !this.getDocument(documentFullName).isNew();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.getContext().setDatabase(MAIN_WIKI_NAME);
        this.getContext().setMainXWiki(MAIN_WIKI_NAME);
        this.databases.put(MAIN_WIKI_NAME, new HashMap());
        this.mockStore = this.mock(XWikiStoreInterface.class, new Class[0], new Object[0]);
        this.mockStore.stubs().method("searchDocuments").will(this.returnValue(Collections.EMPTY_LIST));
        this.mockGroupService = this.mock(XWikiGroupService.class, new Class[0], new Object[0]);
        this.mockGroupService.stubs().method("getAllGroupsNamesForMember").will(this.returnValue(Collections.EMPTY_LIST));
        this.mockGroupService.stubs().method("getAllMatchedGroups").will(this.returnValue(Collections.EMPTY_LIST));
        Mock mockXWiki = this.mock(XWiki.class, new Class[0], new Object[0]);
        mockXWiki.stubs().method("getStore").will(this.returnValue(this.mockStore.proxy()));
        mockXWiki.stubs().method("getGroupService").will(this.returnValue(this.mockGroupService.proxy()));
        mockXWiki.stubs().method("getCacheFactory").will(this.returnValue(this.cacheFactory));
        mockXWiki.stubs().method("getXWikiPreference").will(this.returnValue(null));
        mockXWiki.stubs().method("getXWikiPreferenceAsInt").will(this.throwException(new NumberFormatException("null")));
        mockXWiki.stubs().method("isVirtualMode").will(this.returnValue(this.isVirtualMode));
        mockXWiki.stubs().method("getDefaultDocumentSyntax").will(this.returnValue(XWikiDocument.XWIKI10_SYNTAXID));
        mockXWiki.stubs().method("Param").will((Stub)new CustomStub("Implements XWiki.Param"){

            public Object invoke(Invocation invocation) throws Throwable {
                return XWikiLDAPAuthServiceImplTest.this.properties.getProperty((String)invocation.parameterValues.get(0));
            }
        });
        mockXWiki.stubs().method("ParamAsLong").will((Stub)new CustomStub("Implements XWiki.ParamAsLong"){

            public Object invoke(Invocation invocation) throws Throwable {
                return Long.parseLong(XWikiLDAPAuthServiceImplTest.this.properties.getProperty((String)invocation.parameterValues.get(0)));
            }
        });
        mockXWiki.stubs().method("getDocument").will((Stub)new CustomStub("Implements XWiki.getDocument"){

            public Object invoke(Invocation invocation) throws Throwable {
                return XWikiLDAPAuthServiceImplTest.this.getDocument((String)invocation.parameterValues.get(0));
            }
        });
        mockXWiki.stubs().method("saveDocument").will((Stub)new CustomStub("Implements XWiki.saveDocument"){

            public Object invoke(Invocation invocation) throws Throwable {
                XWikiLDAPAuthServiceImplTest.this.saveDocument((XWikiDocument)invocation.parameterValues.get(0));
                return null;
            }
        });
        mockXWiki.stubs().method("exists").will((Stub)new CustomStub("Implements XWiki.exists"){

            public Object invoke(Invocation invocation) throws Throwable {
                return XWikiLDAPAuthServiceImplTest.this.documentExists((String)invocation.parameterValues.get(0));
            }
        });
        mockXWiki.stubs().method("getClass").will((Stub)new CustomStub("Implements XWiki.getClass"){

            public Object invoke(Invocation invocation) throws Throwable {
                return XWikiLDAPAuthServiceImplTest.this.getDocument((String)invocation.parameterValues.get(0)).getxWikiClass();
            }
        });
        mockXWiki.stubs().method("search").will(this.returnValue(Collections.EMPTY_LIST));
        this.userClass.setName(USER_XCLASS);
        this.userClass.addTextField("first_name", "First Name", 30);
        this.userClass.addTextField("last_name", "Last Name", 30);
        this.userClass.addTextField("email", "e-Mail", 30);
        this.userClass.addPasswordField("password", "Password", 10);
        this.userClass.addTextField("customproperty", "Custom property", 10);
        mockXWiki.stubs().method("getUserClass").will(this.returnValue(this.userClass));
        this.groupClass.setName(GROUP_XCLASS);
        this.groupClass.addTextField("member", "Member", 30);
        mockXWiki.stubs().method("getGroupClass").will(this.returnValue(this.groupClass));
        mockXWiki.stubs().method("createUser").will((Stub)new CustomStub("Implements XWiki.createUser"){

            public Object invoke(Invocation invocation) throws Throwable {
                XWikiDocument document = new XWikiDocument();
                document.setFullName("XWiki." + invocation.parameterValues.get(0));
                BaseObject newobject = new BaseObject();
                newobject.setClassName(XWikiLDAPAuthServiceImplTest.this.userClass.getName());
                XWikiLDAPAuthServiceImplTest.this.userClass.fromMap((Map)invocation.parameterValues.get(1), (BaseCollection)newobject);
                document.addObject(XWikiLDAPAuthServiceImplTest.this.userClass.getName(), newobject);
                XWikiLDAPAuthServiceImplTest.this.saveDocument(document);
                return 1;
            }
        });
        this.getContext().setWiki((XWiki)mockXWiki.proxy());
        this.properties.setProperty("xwiki.authentication.ldap", "1");
        this.properties.setProperty("xwiki.authentication.ldap.server", "127.0.0.1");
        this.properties.setProperty("xwiki.authentication.ldap.port", "" + LDAPTestSetup.getLDAPPort());
        this.properties.setProperty("xwiki.authentication.ldap.base_DN", "o=sevenSeas");
        this.properties.setProperty("xwiki.authentication.ldap.bind_DN", "cn={0},ou=people,o=sevenSeas");
        this.properties.setProperty("xwiki.authentication.ldap.bind_pass", "{1}");
        this.properties.setProperty("xwiki.authentication.ldap.UID_attr", "cn");
        this.properties.setProperty("xwiki.authentication.ldap.groupcache_expiration", "1");
        this.properties.setProperty("xwiki.authentication.ldap.try_local", "0");
        this.properties.setProperty("xwiki.authentication.ldap.update_user", "1");
        this.properties.setProperty("xwiki.authentication.ldap.fields_mapping", "last_name=sn,first_name=givenName,fullname=cn,email=mail");
    }

    private void assertAuthenticate(String login, String password, String storedDn) throws XWikiException {
        this.assertAuthenticate(login, password, "XWiki." + login, storedDn);
    }

    private void assertAuthenticate(String login, String password, String xwikiUserName, String storedDn) throws XWikiException {
        this.assertAuthenticate(login, password, xwikiUserName, storedDn, login);
    }

    private void assertAuthenticate(String login, String password, String xwikiUserName, String storedDn, String storedUid) throws XWikiException {
        Principal principal = this.ldapAuth.authenticate(login, password, this.getContext());
        XWikiLDAPAuthServiceImplTest.assertNotNull((Object)principal);
        XWikiLDAPAuthServiceImplTest.assertEquals((String)xwikiUserName, (String)principal.getName());
        XWikiDocument userProfile = this.getDocument(xwikiUserName);
        XWikiLDAPAuthServiceImplTest.assertTrue((String)"The user profile has not been created", (!userProfile.isNew() ? 1 : 0) != 0);
        BaseObject userProfileObj = userProfile.getObject(USER_XCLASS);
        XWikiLDAPAuthServiceImplTest.assertNotNull((String)"The user profile document does not contains user object", (Object)userProfileObj);
        BaseObject ldapProfileObj = userProfile.getObject("XWiki.LDAPProfileClass");
        XWikiLDAPAuthServiceImplTest.assertNotNull((String)"The user profile document does not contains ldap object", (Object)ldapProfileObj);
        XWikiLDAPAuthServiceImplTest.assertEquals((String)storedDn, (String)ldapProfileObj.getStringValue("dn"));
        XWikiLDAPAuthServiceImplTest.assertEquals((String)storedUid, (String)ldapProfileObj.getStringValue("uid"));
    }

    public void testAuthenticate() throws XWikiException {
        this.assertAuthenticate("Horatio Hornblower", "pass", "cn=Horatio Hornblower,ou=people,o=sevenSeas");
    }

    public void testAuthenticateWithWrongUser() throws XWikiException {
        Principal principal = this.ldapAuth.authenticate("WrongUser", "WrongPass", this.getContext());
        XWikiLDAPAuthServiceImplTest.assertNull((Object)principal);
        XWikiDocument userProfile = this.getDocument("XWiki.WrongUser");
        XWikiLDAPAuthServiceImplTest.assertTrue((String)"The user profile has been created", (boolean)userProfile.isNew());
    }

    public void testAuthenticateTwice() throws XWikiException {
        this.assertAuthenticate("Horatio Hornblower", "pass", "cn=Horatio Hornblower,ou=people,o=sevenSeas");
        this.mockStore.stubs().method("searchDocuments").will(this.returnValue(Collections.singletonList(this.getDocument("XWiki.Horatio Hornblower"))));
        this.assertAuthenticate("Horatio Hornblower", "pass", "cn=Horatio Hornblower,ou=people,o=sevenSeas");
    }

    public void testAuthenticateTwiceAndDifferentCase() throws XWikiException {
        this.assertAuthenticate("Horatio Hornblower", "pass", "cn=Horatio Hornblower,ou=people,o=sevenSeas");
        this.mockStore.stubs().method("searchDocuments").will(this.returnValue(Collections.singletonList(this.getDocument("XWiki.Horatio Hornblower"))));
        this.assertAuthenticate("Horatio Hornblower".toUpperCase(), "pass", "XWiki.Horatio Hornblower", "cn=Horatio Hornblower,ou=people,o=sevenSeas", "Horatio Hornblower");
    }

    public void testAuthenticateWhenUidContainsPoints() throws XWikiException {
        this.assertAuthenticate("User.With.Points", "pass", "XWiki." + "User.With.Points".replaceAll("\\.", ""), "cn=User.With.Points,ou=people,o=sevenSeas");
    }

    public void testAuthenticateTwiceWhenDifferentUsersAndUidContainsPoints() throws XWikiException {
        this.assertAuthenticate("User.With.Points", "pass", "XWiki." + "User.With.Points".replaceAll("\\.", ""), "cn=User.With.Points,ou=people,o=sevenSeas");
        this.assertAuthenticate("User.WithPoints", "pass", "XWiki." + "User.WithPoints".replaceAll("\\.", "") + "_1", "cn=User.WithPoints,ou=people,o=sevenSeas");
    }

    public void testAuthenticateWhenNonLDAPUserAlreadyExists() throws XWikiException {
        XWikiDocument userDoc = this.getDocument("XWiki.Horatio Hornblower");
        userDoc.newObject(this.userClass.getName(), this.getContext());
        this.saveDocument(userDoc);
        this.assertAuthenticate("Horatio Hornblower", "pass", "cn=Horatio Hornblower,ou=people,o=sevenSeas");
    }

    public void testAuthenticateWhenNonLDAPNonUserAlreadyExists() throws XWikiException {
        XWikiDocument userDoc = this.getDocument("XWiki.Horatio Hornblower");
        this.saveDocument(userDoc);
        this.assertAuthenticate("Horatio Hornblower", "pass", "XWiki.Horatio Hornblower_1", "cn=Horatio Hornblower,ou=people,o=sevenSeas");
    }

    public void testAuthenticateWithGroupMembership() throws XWikiException {
        this.saveDocument(this.getDocument("XWiki.Group1"));
        this.properties.setProperty("xwiki.authentication.ldap.group_mapping", "XWiki.Group1=cn=HMS Lydia,ou=crews,ou=groups,o=sevenSeas");
        this.assertAuthenticate("Horatio Hornblower", "pass", "cn=Horatio Hornblower,ou=people,o=sevenSeas");
        Vector groupList = this.getDocument("XWiki.Group1").getObjects(this.groupClass.getName());
        XWikiLDAPAuthServiceImplTest.assertTrue((String)"No user has been added to the group", (groupList != null && groupList.size() > 0 ? 1 : 0) != 0);
        BaseObject groupObject = (BaseObject)groupList.get(0);
        XWikiLDAPAuthServiceImplTest.assertEquals((String)"XWiki.Horatio Hornblower", (String)groupObject.getStringValue("member"));
    }

    public void testAuthenticateWithGroupMembershipWhenOneXWikiGroupMapTwoLDAPGroups() throws XWikiException {
        this.saveDocument(this.getDocument("XWiki.Group1"));
        this.properties.setProperty("xwiki.authentication.ldap.group_mapping", "XWiki.Group1=cn=HMS Lydia,ou=crews,ou=groups,o=sevenSeas|XWiki.Group1=cn=Exlude Group,ou=crews,ou=groups,o=sevenSeas");
        this.assertAuthenticate("Horatio Hornblower", "pass", "cn=Horatio Hornblower,ou=people,o=sevenSeas");
        Vector groupList = this.getDocument("XWiki.Group1").getObjects(this.groupClass.getName());
        XWikiLDAPAuthServiceImplTest.assertTrue((String)"No user has been added to the group", (groupList != null && groupList.size() > 0 ? 1 : 0) != 0);
        BaseObject groupObject = (BaseObject)groupList.get(0);
        XWikiLDAPAuthServiceImplTest.assertEquals((String)"XWiki.Horatio Hornblower", (String)groupObject.getStringValue("member"));
    }

    public void testAuthenticateTwiceWithGroupMembership() throws XWikiException {
        this.saveDocument(this.getDocument("XWiki.Group1"));
        this.properties.setProperty("xwiki.authentication.ldap.group_mapping", "XWiki.Group1=cn=HMS Lydia,ou=crews,ou=groups,o=sevenSeas");
        this.mockGroupService.stubs().method("getAllMatchedGroups").will(this.returnValue(Collections.singletonList("XWiki.Group1")));
        this.assertAuthenticate("Horatio Hornblower", "pass", "cn=Horatio Hornblower,ou=people,o=sevenSeas");
        this.mockGroupService.stubs().method("getAllGroupsNamesForMember").will(this.returnValue(Collections.singletonList("XWiki.Group1")));
        this.assertAuthenticate("Horatio Hornblower", "pass", "cn=Horatio Hornblower,ou=people,o=sevenSeas");
        Vector groupList = this.getDocument("XWiki.Group1").getObjects(this.groupClass.getName());
        XWikiLDAPAuthServiceImplTest.assertTrue((String)"No user has been added to the group", (groupList != null ? 1 : 0) != 0);
        XWikiLDAPAuthServiceImplTest.assertTrue((String)"The user has been added twice in the group", (groupList.size() == 1 ? 1 : 0) != 0);
        BaseObject groupObject = (BaseObject)groupList.get(0);
        XWikiLDAPAuthServiceImplTest.assertEquals((String)"XWiki.Horatio Hornblower", (String)groupObject.getStringValue("member"));
        this.assertAuthenticate("Horatio Hornblower", "pass", "cn=Horatio Hornblower,ou=people,o=sevenSeas");
    }

    public void testAuthenticateUserSync() throws XWikiException {
        this.assertAuthenticate("Horatio Hornblower", "pass", "cn=Horatio Hornblower,ou=people,o=sevenSeas");
        XWikiDocument userProfile = this.getDocument("XWiki.Horatio Hornblower");
        BaseObject userProfileObj = userProfile.getObject(USER_XCLASS);
        XWikiLDAPAuthServiceImplTest.assertEquals((String)"Hornblower", (String)userProfileObj.getStringValue("last_name"));
        XWikiLDAPAuthServiceImplTest.assertEquals((String)"Horatio", (String)userProfileObj.getStringValue("first_name"));
        XWikiLDAPAuthServiceImplTest.assertEquals((String)"hhornblo@royalnavy.mod.uk", (String)userProfileObj.getStringValue("email"));
        userProfileObj.setStringValue("customproperty", "customvalue");
        this.assertAuthenticate("Horatio Hornblower", "pass", "cn=Horatio Hornblower,ou=people,o=sevenSeas");
        userProfile = this.getDocument("XWiki.Horatio Hornblower");
        userProfileObj = userProfile.getObject(USER_XCLASS);
        XWikiLDAPAuthServiceImplTest.assertEquals((String)"customvalue", (String)userProfileObj.getStringValue("customproperty"));
    }

    public void testAuthenticateUserSyncWithoutMapping() throws XWikiException {
        this.properties.setProperty("xwiki.authentication.ldap.fields_mapping", "");
        this.assertAuthenticate("Horatio Hornblower", "pass", "cn=Horatio Hornblower,ou=people,o=sevenSeas");
        this.properties.remove("xwiki.authentication.ldap.fields_mapping");
        this.assertAuthenticate("Horatio Hornblower", "pass", "cn=Horatio Hornblower,ou=people,o=sevenSeas");
    }
}

