/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.it.framework.AbstractLDAPTestCase;
import com.xpn.xwiki.it.framework.LDAPTestSetup;
import com.xpn.xwiki.plugin.ldap.XWikiLDAPConnection;
import com.xpn.xwiki.plugin.ldap.XWikiLDAPSearchAttribute;
import com.xpn.xwiki.plugin.ldap.XWikiLDAPUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jmock.Mock;
import org.jmock.core.Invocation;
import org.jmock.core.Stub;
import org.jmock.core.stub.CustomStub;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheFactory;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.internal.DefaultCache;

public class XWikiLDAPUtilsTest
extends AbstractLDAPTestCase {
    private CacheFactory cacheFactory = new CacheFactory(){

        public <T> Cache<T> newCache(CacheConfiguration config) throws CacheException {
            return new DefaultCache();
        }
    };
    private XWikiLDAPConnection connection = new XWikiLDAPConnection();
    private XWikiLDAPUtils ldapUtils = new XWikiLDAPUtils(this.connection);
    private Properties properties = new Properties();

    public void setUp() throws Exception {
        super.setUp();
        Mock mockXWiki = this.mock(XWiki.class, new Class[0], new Object[0]);
        mockXWiki.stubs().method("getCacheFactory").will(this.returnValue(this.cacheFactory));
        mockXWiki.stubs().method("getXWikiPreference").will(this.returnValue(null));
        mockXWiki.stubs().method("getXWikiPreferenceAsInt").will(this.throwException(new NumberFormatException("null")));
        mockXWiki.stubs().method("Param").will((Stub)new CustomStub("Implements XWiki.Param"){

            public Object invoke(Invocation invocation) throws Throwable {
                return XWikiLDAPUtilsTest.this.properties.getProperty((String)invocation.parameterValues.get(0));
            }
        });
        mockXWiki.stubs().method("ParamAsLong").will((Stub)new CustomStub("Implements XWiki.ParamAsLong"){

            public Object invoke(Invocation invocation) throws Throwable {
                return Long.parseLong(XWikiLDAPUtilsTest.this.properties.getProperty((String)invocation.parameterValues.get(0)));
            }
        });
        this.getContext().setWiki((XWiki)mockXWiki.proxy());
        this.properties.setProperty("xwiki.authentication.ldap", "1");
        this.properties.setProperty("xwiki.authentication.ldap.server", "127.0.0.1");
        this.properties.setProperty("xwiki.authentication.ldap.port", "" + LDAPTestSetup.getLDAPPort());
        this.properties.setProperty("xwiki.authentication.ldap.base_DN", "o=sevenSeas");
        this.properties.setProperty("xwiki.authentication.ldap.bind_DN", "cn={0},ou=people,o=sevenSeas");
        this.properties.setProperty("xwiki.authentication.ldap.bind_pass", "{1}");
        this.properties.setProperty("xwiki.authentication.ldap.UID_attr", "cn");
        this.properties.setProperty("xwiki.authentication.ldap.groupcache_expiration", "1");
        this.ldapUtils.setUidAttributeName("cn");
        this.ldapUtils.setBaseDN("o=sevenSeas");
        int port = LDAPTestSetup.getLDAPPort();
        this.connection.open("localhost", port, "cn=Horatio Hornblower,ou=people,o=sevenSeas", "pass", null, false, this.getContext());
    }

    public void tearDown() throws Exception {
        this.connection.close();
        super.tearDown();
    }

    public void testGetUidAttributeName() {
        XWikiLDAPUtilsTest.assertSame((String)"Wrong uid attribute name", (Object)"cn", (Object)this.ldapUtils.getUidAttributeName());
    }

    public void testCache() throws XWikiException, InterruptedException, CacheException {
        CacheConfiguration cacheConfigurationGroups = new CacheConfiguration();
        Cache tmpCache = this.ldapUtils.getCache(cacheConfigurationGroups, this.getContext());
        Cache cache = this.ldapUtils.getCache(cacheConfigurationGroups, this.getContext());
        XWikiLDAPUtilsTest.assertSame((String)"Cache is recreated", (Object)tmpCache, (Object)cache);
    }

    public void testSearchUserAttributesByUid() {
        List attributes = this.ldapUtils.searchUserAttributesByUid("Moultrie Crystal", new String[]{"dn", "cn"});
        HashMap<String, String> mexpected = new HashMap<String, String>();
        mexpected.put("dn", "cn=Moultrie Crystal,ou=people,o=sevenSeas");
        mexpected.put("cn", "Moultrie Crystal");
        HashMap<String, String> mresult = new HashMap<String, String>();
        for (XWikiLDAPSearchAttribute att : attributes) {
            mresult.put(att.name, att.value);
        }
        XWikiLDAPUtilsTest.assertEquals(mexpected, mresult);
    }

    public void testSearchUserDNByUid() {
        String userDN = this.ldapUtils.searchUserDNByUid("Horatio Hornblower");
        XWikiLDAPUtilsTest.assertEquals((String)"cn=Horatio Hornblower,ou=people,o=sevenSeas", (String)userDN);
    }

    public void testGetGroupMembers() throws XWikiException {
        Map members = this.ldapUtils.getGroupMembers("cn=HMS Lydia,ou=crews,ou=groups,o=sevenSeas", this.getContext());
        XWikiLDAPUtilsTest.assertFalse((String)"No member was found", (boolean)members.isEmpty());
        XWikiLDAPUtilsTest.assertEquals(LDAPTestSetup.HMSLYDIA_MEMBERS, members.keySet());
        Map wrongGroupMembers = this.ldapUtils.getGroupMembers("cn=wronggroupdn,ou=people,o=sevenSeas", this.getContext());
        XWikiLDAPUtilsTest.assertNull((String)("Should return null if group does not exists [" + wrongGroupMembers + "]"), (Object)wrongGroupMembers);
    }

    public void testIsUserInGroup() throws XWikiException {
        String userDN = this.ldapUtils.isUidInGroup("Horatio Hornblower", "cn=HMS Lydia,ou=crews,ou=groups,o=sevenSeas", this.getContext());
        XWikiLDAPUtilsTest.assertNotNull((String)"User Horatio Hornblower not found", (Object)userDN);
        XWikiLDAPUtilsTest.assertEquals((String)"cn=Horatio Hornblower,ou=people,o=sevenSeas".toLowerCase(), (String)userDN);
        this.ldapUtils.setUidAttributeName("uid");
        userDN = this.ldapUtils.isUidInGroup("wbush", "cn=HMS Lydia,ou=crews,ou=groups,o=sevenSeas", this.getContext());
        XWikiLDAPUtilsTest.assertNotNull((String)"User wbush not found", (Object)userDN);
        XWikiLDAPUtilsTest.assertEquals((String)"cn=William Bush,ou=people,o=sevenSeas".toLowerCase(), (String)userDN);
        String wrongUserDN = this.ldapUtils.isUidInGroup("wronguseruid", "cn=HMS Lydia,ou=crews,ou=groups,o=sevenSeas", this.getContext());
        XWikiLDAPUtilsTest.assertNull((String)"Should return null if user is not in the group", (Object)wrongUserDN);
    }

    public void testIsMemberOfGroup() throws XWikiException {
        XWikiLDAPUtilsTest.assertTrue((boolean)this.ldapUtils.isMemberOfGroup("cn=Horatio Hornblower,ou=people,o=sevenSeas", "cn=HMS Lydia,ou=crews,ou=groups,o=sevenSeas", this.getContext()));
        XWikiLDAPUtilsTest.assertFalse((boolean)this.ldapUtils.isMemberOfGroup("cn=Horatio Hornblower,ou=people,o=sevenSeas", "cn=Exlude Group,ou=crews,ou=groups,o=sevenSeas", this.getContext()));
    }

    public void testIsMemberOfGroups() throws XWikiException {
        XWikiLDAPUtilsTest.assertTrue((boolean)this.ldapUtils.isMemberOfGroups("cn=Horatio Hornblower,ou=people,o=sevenSeas", Arrays.asList("cn=HMS Lydia,ou=crews,ou=groups,o=sevenSeas", "cn=Exlude Group,ou=crews,ou=groups,o=sevenSeas"), this.getContext()));
        XWikiLDAPUtilsTest.assertTrue((boolean)this.ldapUtils.isMemberOfGroups("cn=Horatio Hornblower,ou=people,o=sevenSeas", Arrays.asList("cn=Exlude Group,ou=crews,ou=groups,o=sevenSeas", "cn=HMS Lydia,ou=crews,ou=groups,o=sevenSeas"), this.getContext()));
    }
}

