/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it.selenium;

import com.xpn.xwiki.it.selenium.framework.AbstractXWikiTestCase;
import com.xpn.xwiki.it.selenium.framework.XWikiTestSuite;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.Test;

public class DeletePageTest
extends AbstractXWikiTestCase {
    static /* synthetic */ Class class$com$xpn$xwiki$it$selenium$DeletePageTest;
    static /* synthetic */ Class class$com$xpn$xwiki$it$selenium$framework$AlbatrossSkinExecutor;

    public static Test suite() {
        XWikiTestSuite suite = new XWikiTestSuite("Verify deletion of pages");
        suite.addTestSuite(class$com$xpn$xwiki$it$selenium$DeletePageTest == null ? (class$com$xpn$xwiki$it$selenium$DeletePageTest = DeletePageTest.class$("com.xpn.xwiki.it.selenium.DeletePageTest")) : class$com$xpn$xwiki$it$selenium$DeletePageTest, class$com$xpn$xwiki$it$selenium$framework$AlbatrossSkinExecutor == null ? (class$com$xpn$xwiki$it$selenium$framework$AlbatrossSkinExecutor = DeletePageTest.class$("com.xpn.xwiki.it.selenium.framework.AlbatrossSkinExecutor")) : class$com$xpn$xwiki$it$selenium$framework$AlbatrossSkinExecutor);
        return suite;
    }

    public void testDeleteOkWhenConfirming() {
        this.logInAndCreatePageToBeDeleted("DeleteTest");
        this.clickDeletePage();
        this.clickLinkWithLocator("//input[@value='yes']");
        this.assertTextPresent("The document has been deleted.");
    }

    public void testDeletePageCanSkipConfirmationAndDoARedirect() {
        this.logInAndCreatePageToBeDeleted("DeleteTest");
        this.open("/xwiki/bin/delete/Test/DeleteTest?confirm=1&xredirect=/xwiki/bin/view/Main/");
        this.assertPage("Main", "WebHome");
    }

    public void testDeletePageCanDoRedirect() {
        this.logInAndCreatePageToBeDeleted("DeleteTest");
        this.open("/xwiki/bin/delete/Test/DeleteTest?xredirect=/xwiki/bin/view/Main/");
        this.clickLinkWithLocator("//input[@value='yes']");
        this.assertPage("Main", "WebHome");
    }

    public void testDeletePageGoesToOriginalPageWhenCancelled() {
        this.logInAndCreatePageToBeDeleted("DeleteTestNoDelete");
        this.open("/xwiki/bin/delete/Test/DeleteTestNoDelete");
        this.clickLinkWithLocator("//input[@value='no']");
        this.assertPage("Test", "DeleteTestNoDelete");
    }

    public void testDeletePageIsImpossibleWhenNoDeleteRights() {
        this.open("/xwiki/bin/view/Main/");
        if (this.isAuthenticated()) {
            this.logout();
        }
        try {
            this.clickDeletePage();
            Assert.fail((String)"Should have failed here as the Delete button shouldn't be present");
        }
        catch (AssertionFailedError expected) {
            Assert.assertTrue((boolean)expected.getMessage().endsWith("isn't present."));
        }
    }

    public void testInterfaceShouldNotShowUserAsLoggedOutWhileDeletingPage() {
        this.logInAndCreatePageToBeDeleted("DeleteTest");
        this.clickDeletePage();
        Assert.assertTrue((String)"The interface should not show the user as logged out while deleting page", (boolean)this.isAuthenticated());
    }

    private void logInAndCreatePageToBeDeleted(String pageName) {
        this.loginAsAdmin();
        this.open("/xwiki/bin/edit/Test/" + pageName + "?editor=wiki");
        this.setFieldValue("content", "some content");
        this.clickEditSaveAndView();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

