/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it.selenium;

import com.xpn.xwiki.it.selenium.framework.AbstractXWikiTestCase;
import com.xpn.xwiki.it.selenium.framework.XWikiTestSuite;
import junit.framework.Test;

public class RegisterTest
extends AbstractXWikiTestCase {
    static /* synthetic */ Class class$com$xpn$xwiki$it$selenium$RegisterTest;
    static /* synthetic */ Class class$com$xpn$xwiki$it$selenium$framework$AlbatrossSkinExecutor;

    public static Test suite() {
        XWikiTestSuite suite = new XWikiTestSuite("Tries to register a new xwiki user");
        suite.addTestSuite(class$com$xpn$xwiki$it$selenium$RegisterTest == null ? (class$com$xpn$xwiki$it$selenium$RegisterTest = RegisterTest.class$("com.xpn.xwiki.it.selenium.RegisterTest")) : class$com$xpn$xwiki$it$selenium$RegisterTest, class$com$xpn$xwiki$it$selenium$framework$AlbatrossSkinExecutor == null ? (class$com$xpn$xwiki$it$selenium$framework$AlbatrossSkinExecutor = RegisterTest.class$("com.xpn.xwiki.it.selenium.framework.AlbatrossSkinExecutor")) : class$com$xpn$xwiki$it$selenium$framework$AlbatrossSkinExecutor);
        return suite;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.open(this.getUrl("Main", "WebHome"));
        if (this.isAuthenticated()) {
            this.logout();
        }
        if (this.documentExists("XWiki", "JohnSmith")) {
            this.deleteDocument("XWiki", "JohnSmith");
        }
        this.clickRegister();
    }

    public void tearDown() throws Exception {
        if (this.documentExists("XWiki", "JohnSmith")) {
            this.deleteDocument("XWiki", "JohnSmith");
        }
        super.tearDown();
    }

    private void fillFormWithJohnSmithValues() {
        this.setFieldValue("register_first_name", "John");
        this.setFieldValue("register_last_name", "Smith");
        this.setFieldValue("xwikiname", "JohnSmith");
        this.setFieldValue("register_password", "JohnSmith");
        this.setFieldValue("register2_password", "JohnSmith");
        this.setFieldValue("register_email", "JohnSmith@example.com");
    }

    public void testRegisterJohnSmith() {
        this.fillFormWithJohnSmithValues();
        this.submit();
        this.assertTextPresent("Registration successful");
        this.clickLinkWithLocator("link=John Smith");
        this.assertTextPresent("Profile of John Smith");
        this.login("JohnSmith", "JohnSmith", false);
    }

    public void testRegisterExistingUser() {
        this.fillFormWithJohnSmithValues();
        this.setFieldValue("xwikiname", "Admin");
        this.submit();
        this.assertTextPresent("User already exists.");
    }

    public void testRegisterWithTwoDifferentPasswords() {
        this.fillFormWithJohnSmithValues();
        this.setFieldValue("register_password", "a");
        this.setFieldValue("register2_password", "b");
        this.submit();
        this.assertTextPresent("Passwords are different or password is empty.");
    }

    public void testRegisterWithoutEnteringUserName() {
        this.fillFormWithJohnSmithValues();
        this.setFieldValue("xwikiname", "");
        this.submit();
        this.assertTextPresent("Invalid username provided");
    }

    public void testRegisterWithoutEnteringPassword() {
        this.fillFormWithJohnSmithValues();
        this.setFieldValue("register_password", "");
        this.setFieldValue("register2_password", "");
        this.submit();
        this.assertTextPresent("Passwords are different or password is empty.");
    }

    private void deleteDocument(String space, String doc) {
        this.loginAsAdmin();
        this.open("/xwiki/bin/delete/" + space + "/" + doc + "?confirm=1");
        this.assertTextPresent("The document has been deleted.");
        this.logout();
    }

    private boolean documentExists(String space, String doc) {
        String saveUrl = this.getSelenium().getLocation();
        this.open(this.getUrl(space, doc));
        boolean exists = this.getTitle().equals("XWiki - " + space + " - " + doc) && !this.getSelenium().isTextPresent("The requested document could not be found.");
        this.open(saveUrl);
        return exists;
    }

    private String getUrl(String space, String doc) {
        return this.getUrl(space, doc, "view");
    }

    private String getUrl(String space, String doc, String action) {
        return "/xwiki/bin/" + action + "/" + space + "/" + doc;
    }

    private String getUrl(String space, String doc, String action, String param) {
        return this.getUrl(space, doc, action) + "?" + param;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

