/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it.selenium;

import com.xpn.xwiki.it.selenium.framework.AbstractXWikiTestCase;
import com.xpn.xwiki.it.selenium.framework.XWikiTestSuite;
import junit.framework.Assert;
import junit.framework.Test;

public class WysiwygEditorFromWikiTest
extends AbstractXWikiTestCase {
    static /* synthetic */ Class class$com$xpn$xwiki$it$selenium$WysiwygEditorFromWikiTest;
    static /* synthetic */ Class class$com$xpn$xwiki$it$selenium$framework$AlbatrossSkinExecutor;

    public static Test suite() {
        XWikiTestSuite suite = new XWikiTestSuite("Tests the wiki editor");
        suite.addTestSuite(class$com$xpn$xwiki$it$selenium$WysiwygEditorFromWikiTest == null ? (class$com$xpn$xwiki$it$selenium$WysiwygEditorFromWikiTest = WysiwygEditorFromWikiTest.class$("com.xpn.xwiki.it.selenium.WysiwygEditorFromWikiTest")) : class$com$xpn$xwiki$it$selenium$WysiwygEditorFromWikiTest, class$com$xpn$xwiki$it$selenium$framework$AlbatrossSkinExecutor == null ? (class$com$xpn$xwiki$it$selenium$framework$AlbatrossSkinExecutor = WysiwygEditorFromWikiTest.class$("com.xpn.xwiki.it.selenium.framework.AlbatrossSkinExecutor")) : class$com$xpn$xwiki$it$selenium$framework$AlbatrossSkinExecutor);
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.loginAsAdmin();
        this.open("/xwiki/bin/edit/Test/WysiwygEdit?editor=wiki");
    }

    public void testIndentedOrderedList() throws Exception {
        this.setFieldValue("content", "1. level 1\n11. level 2");
        this.clickLinkWithText("WYSIWYG");
        this.assertHTMLGeneratedByWysiwyg("ol/li[text()='level 1']");
        this.assertHTMLGeneratedByWysiwyg("ol/ol/li[text()='level 2']");
        this.clickLinkWithText("Wiki");
        Assert.assertEquals((String)"1. level 1\n11. level 2", (String)this.getFieldValue("content"));
    }

    public void testAutomaticConversionFromHashSyntaxToNumberSyntaxForOrderedLists() {
        this.setFieldValue("content", "# item 1\n## item 2\n# item 3");
        this.clickLinkWithText("WYSIWYG");
        this.clickLinkWithText("Wiki");
        Assert.assertEquals((String)"1. item 1\n11. item 2\n1. item 3", (String)this.getFieldValue("content"));
    }

    public void testHorizontalLineBeforeTableMacro() {
        this.setFieldValue("content", "----\n\n{table}\na | b\nc | d\n{table}");
        this.clickLinkWithText("WYSIWYG");
        this.clickLinkWithText("Wiki");
        Assert.assertEquals((String)"----\n\n{table}\na | b\nc | d\n{table}", (String)this.getFieldValue("content"));
    }

    public void testBulletedLists() throws Exception {
        this.setFieldValue("content", "- item 1\n-- item 2\n- item 3");
        this.clickLinkWithText("WYSIWYG");
        this.assertHTMLGeneratedByWysiwyg("ul/li[text()='item 1']");
        this.assertHTMLGeneratedByWysiwyg("ul/ul/li[text()='item 2']");
        this.assertHTMLGeneratedByWysiwyg("ul/li[text()='item 3']");
        this.clickLinkWithText("Wiki");
        Assert.assertEquals((String)"- item 1\n-- item 2\n- item 3", (String)this.getFieldValue("content"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

