/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it.selenium.framework;

import com.xpn.xwiki.it.selenium.framework.AbstractXWikiTestCase;
import com.xpn.xwiki.it.selenium.framework.SkinExecutor;
import junit.framework.Assert;

public class AlbatrossSkinExecutor
implements SkinExecutor {
    private static final String WYSIWYG_LOCATOR_FOR_KEY_EVENTS = "mceSpanFonts";
    private static final String WIKI_LOCATOR_FOR_KEY_EVENTS = "content";
    private AbstractXWikiTestCase test;

    public AlbatrossSkinExecutor(AbstractXWikiTestCase test) {
        this.test = test;
    }

    private AbstractXWikiTestCase getTest() {
        return this.test;
    }

    public void clickDeletePage() {
        this.getTest().clickLinkWithLocator("//a[string() = 'Delete']");
    }

    public void clickEditPreview() {
        this.getTest().submit("formactionpreview");
    }

    public void clickEditSaveAndContinue() {
        this.getTest().submit("formactionsac");
    }

    public void clickEditCancelEdition() {
        this.getTest().submit("formactioncancel");
    }

    public void clickEditSaveAndView() {
        this.getTest().submit("formactionsave");
    }

    public boolean isAuthenticated() {
        return !this.getTest().isElementPresent("headerlogin") || !this.getTest().isElementPresent("headerregister");
    }

    public void logout() {
        this.getTest();
        Assert.assertTrue((String)"User wasn't authenticated.", (boolean)this.isAuthenticated());
        this.getTest().clickLinkWithLocator("headerlogout");
        this.getTest();
        Assert.assertFalse((String)"The user is still authenticated after a logout.", (boolean)this.isAuthenticated());
    }

    public void login(String username, String password, boolean rememberme) {
        this.getTest().open("/xwiki/bin/view/Main/");
        if (this.isAuthenticated()) {
            this.logout();
        }
        this.clickLogin();
        this.getTest().setFieldValue("j_username", username);
        this.getTest().setFieldValue("j_password", password);
        if (rememberme) {
            this.getTest().checkField("rememberme");
        }
        this.getTest().submit();
        this.getTest();
        Assert.assertTrue((String)"User has not been authenticated", (boolean)this.isAuthenticated());
    }

    public void loginAsAdmin() {
        this.login("Admin", "admin", false);
    }

    public void clickLogin() {
        this.getTest().clickLinkWithLocator("headerlogin");
        this.assertIsLoginPage();
    }

    private void assertIsLoginPage() {
        this.getTest().assertElementPresent("loginForm");
        this.getTest().assertElementPresent("j_username");
        this.getTest().assertElementPresent("j_password");
        this.getTest().assertElementPresent("rememberme");
    }

    public void clickRegister() {
        this.getTest().clickLinkWithLocator("headerregister");
        this.assertIsRegisterPage();
    }

    private void assertIsRegisterPage() {
        this.getTest().assertElementPresent("register");
        this.getTest().assertElementPresent("register_first_name");
        this.getTest().assertElementPresent("register_last_name");
        this.getTest().assertElementPresent("xwikiname");
        this.getTest().assertElementPresent("register_password");
        this.getTest().assertElementPresent("register2_password");
        this.getTest().assertElementPresent("register_email");
    }

    public void editInWysiwyg(String space, String page) {
        this.getTest().open("/xwiki/bin/edit/" + space + "/" + page + "?editor=wysiwyg");
    }

    public void clearWysiwygContent() {
        this.getTest().getSelenium().waitForCondition("selenium.browserbot.getCurrentWindow().tinyMCE.setContent(\"\"); true", "18000");
    }

    public void typeInWysiwyg(String text) {
        this.getTest().getSelenium().typeKeys(WYSIWYG_LOCATOR_FOR_KEY_EVENTS, text);
    }

    public void typeInWiki(String text) {
        this.getTest().getSelenium().type(WIKI_LOCATOR_FOR_KEY_EVENTS, text);
    }

    public void typeEnterInWysiwyg() {
        this.getTest().getSelenium().keyPress(WYSIWYG_LOCATOR_FOR_KEY_EVENTS, "\\13");
    }

    public void typeShiftEnterInWysiwyg() {
        this.getTest().getSelenium().shiftKeyDown();
        this.getTest().getSelenium().keyPress(WYSIWYG_LOCATOR_FOR_KEY_EVENTS, "\\13");
    }

    public void clickWysiwygUnorderedListButton() {
        this.getTest().clickLinkWithLocator("//img[@title='Unordered list']", false);
    }

    public void clickWysiwygOrderedListButton() {
        this.getTest().clickLinkWithLocator("//img[@title='Ordered list']", false);
    }

    public void clickWysiwygIndentButton() {
        this.getTest().clickLinkWithLocator("//img[@title='Indent']", false);
    }

    public void clickWysiwygOutdentButton() {
        this.getTest().clickLinkWithLocator("//img[@title='Outdent']", false);
    }

    public void clickWikiBoldButton() {
        this.getTest().clickLinkWithXPath("//img[@title='Bold']", false);
    }

    public void clickWikiItalicsButton() {
        this.getTest().clickLinkWithXPath("//img[@title='Italics']", false);
    }

    public void clickWikiUnderlineButton() {
        this.getTest().clickLinkWithXPath("//img[@title='Underline']", false);
    }

    public void clickWikiLinkButton() {
        this.getTest().clickLinkWithXPath("//img[@title='Internal Link']", false);
    }

    public void clickWikiHRButton() {
        this.getTest().clickLinkWithXPath("//img[@title='Horizontal ruler']", false);
    }

    public void clickWikiImageButton() {
        this.getTest().clickLinkWithXPath("//img[@title='Attached Image']", false);
    }

    public void clickWikiSignatureButton() {
        this.getTest().clickLinkWithXPath("//img[@title='sig']", false);
    }

    public void assertWikiTextGeneratedByWysiwyg(String text) {
        this.getTest().clickLinkWithText("Wiki");
        this.getTest();
        Assert.assertEquals((String)text, (String)this.getTest().getSelenium().getValue(WIKI_LOCATOR_FOR_KEY_EVENTS));
    }

    public void assertHTMLGeneratedByWysiwyg(String xpath) throws Exception {
        this.getTest().getSelenium().selectFrame("mce_editor_0");
        this.getTest();
        Assert.assertTrue((boolean)this.getTest().getSelenium().isElementPresent("xpath=/html/body/" + xpath));
        this.getTest().getSelenium().selectFrame("relative=top");
    }

    public void assertGeneratedHTML(String xpath) throws Exception {
        this.getTest();
        Assert.assertTrue((boolean)this.getTest().getSelenium().isElementPresent("xpath=//div[@id='xwikicontent']/" + xpath));
    }
}

