/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.it.ui.administration.elements;

import java.net.URL;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.it.ui.framework.elements.ViewPage;

public class ImportPage
extends ViewPage {
    @FindBy(id="packagelistcontainer")
    private WebElement packageList;
    @FindBy(id="xwikiuploadfile")
    private WebElement uploadFileInputField;
    @FindBy(xpath="//input[@type='submit']")
    private WebElement uploadFileSubmit;
    @FindBy(xpath="//input[@value='Import']")
    private WebElement importPackageLink;

    public void gotoPage() {
        this.getUtil().gotoPage("XWiki", "Import", "import", "editor=globaladmin&section=Import");
    }

    public void attachPackage(URL file) {
        this.uploadFileInputField.sendKeys(new CharSequence[]{file.getPath()});
        this.uploadFileSubmit.submit();
    }

    public boolean isPackagePresent(String packageName) {
        return this.packageList.getText().contains(packageName);
    }

    public void selectPackage(String packageName) {
        this.getDriver().findElement(By.linkText((String)packageName)).click();
        this.waitUntilElementIsVisible(By.id((String)"packageDescription"));
    }

    public void deletePackage(String packageName) {
        List packages = this.packageList.findElements(By.xpath((String)"//ul[@class='xlist']/li/div"));
        for (WebElement pack : packages) {
            try {
                pack.findElement(By.partialLinkText((String)packageName));
                this.makeConfirmDialogSilent();
                pack.findElement(By.xpath((String)"//div/span/a[@class='deletelink']")).click();
                return;
            }
            catch (NoSuchElementException e) {
            }
        }
        throw new NoSuchElementException(packageName);
    }

    public void importPackage() {
        this.importPackageLink.click();
        this.waitUntilElementIsVisible(By.xpath((String)"//div[@id='packagecontainer']/div[@class='infomessage']"));
    }

    public ViewPage clickImportedPage(String pageName) {
        this.waitUntilElementIsVisible(By.linkText((String)pageName));
        this.getDriver().findElement(By.linkText((String)pageName)).click();
        return new ViewPage();
    }

    public void selectReplaceHistoryOption() {
        this.getDriver().findElement(By.xpath((String)"//input[@name='historyStrategy' and @value='replace']")).click();
    }
}

