/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.it.ui.blog.elements;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.it.ui.framework.elements.BasePage;

public class ManageCategoriesPage
extends BasePage {
    @FindBy(xpath="//li/span[@class='blog-add-category-label']/a")
    private WebElement addCategoryLink;
    @FindBy(xpath="//form[@class='category-add-form']//input[@type='submit']")
    private WebElement addButton;
    @FindBy(xpath="//form[@class='category-add-form']//a[text()='Cancel']")
    private WebElement cancelLink;
    @FindBy(xpath="//input[@class='category-name-input']")
    private WebElement nameInput;
    @FindBy(xpath="//form[@class='category-rename-form']//input[@type='submit']")
    private WebElement renameButton;

    public void gotoPage() {
        this.getUtil().gotoPage("Blog", "ManageCategories", "view");
    }

    public void clickAddCategory() {
        this.addCategoryLink.click();
        this.waitUntilElementIsVisible(By.className((String)"category-add-form"));
    }

    public void cancelAddingCategory() {
        this.cancelLink.click();
    }

    public void addCategory(String name) {
        this.nameInput.sendKeys(new CharSequence[]{name});
        this.addButton.submit();
        this.waitUntilElementIsVisible(this.categoryLocator(name));
    }

    public void deleteCategory(String name) {
        By deletePath = By.xpath((String)("//a[@class='tool delete' and contains(@href, '" + this.getUtil().escapeURL(name) + "')]/img"));
        this.hoverCategoryItem(name);
        this.waitUntilElementIsVisible(deletePath);
        this.getDriver().findElement(deletePath).click();
        this.waitUntilElementIsVisible(By.xpath((String)"//div[@class='xdialog-screen']"));
        this.getDriver().findElement(By.xpath((String)"//div[@class='xdialog-modal-container']//input[@value='Yes']")).click();
        this.waitUntilElementDisappears(this.categoryLocator(name));
    }

    public void renameCategory(String fromName, String toName) {
        By renamePath = By.xpath((String)("//a[@class='tool rename' and contains(@href, '" + this.getUtil().escapeURL(fromName) + "')]/img"));
        this.hoverCategoryItem(fromName);
        this.waitUntilElementIsVisible(renamePath);
        this.getDriver().findElement(renamePath).click();
        this.waitUntilElementIsVisible(By.className((String)"category-rename-form"));
        this.nameInput.sendKeys(new CharSequence[]{toName});
        this.renameButton.submit();
        this.waitUntilElementIsVisible(this.categoryLocator(toName));
    }

    public boolean isCategoryPresent(String name) {
        return !this.getDriver().findElements(this.categoryLocator(name)).isEmpty();
    }

    private void hoverCategoryItem(String name) {
        By locator = By.xpath((String)("//a[@class='tool delete' and contains(@href, '" + this.getUtil().escapeURL(name) + "')]/ancestor::span[@class='blog-category-tools']"));
        this.makeElementVisible(locator);
    }

    private By categoryLocator(String name) {
        return By.xpath((String)("//span[@class='blog-category']//a[contains(@href, '" + this.getUtil().escapeURL(name) + "')]"));
    }
}

