/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.it.ui.framework.elements;

import com.google.common.base.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.AjaxElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.TimeoutException;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.xwiki.it.ui.framework.PersistentTestContext;
import org.xwiki.it.ui.framework.TestUtils;

public class BaseElement {
    private static PersistentTestContext context;

    public static void setContext(PersistentTestContext context) {
        BaseElement.context = context;
    }

    public BaseElement() {
        AjaxElementLocatorFactory finder = new AjaxElementLocatorFactory(this.getDriver(), this.getUtil().getTimeout());
        PageFactory.initElements((ElementLocatorFactory)finder, (Object)this);
    }

    protected WebDriver getDriver() {
        return context.getDriver();
    }

    protected TestUtils getUtil() {
        return context.getUtil();
    }

    public void waitUntilElementIsVisible(By locator) {
        this.waitUntilElementIsVisible(locator, this.getUtil().getTimeout());
    }

    public void waitUntilElementIsVisible(By locator, int timeout) {
        this.waitUntilElementsAreVisible(new By[]{locator}, timeout, true);
    }

    public void waitUntilElementsAreVisible(By[] locators, boolean all) {
        this.waitUntilElementsAreVisible(locators, this.getUtil().getTimeout(), all);
    }

    public void waitUntilElementsAreVisible(final By[] locators, int timeout, final boolean all) {
        WebDriverWait wait = new WebDriverWait(this.getDriver(), (long)timeout);
        try {
            wait.until((Function)new ExpectedCondition<WebElement>(){

                public WebElement apply(WebDriver driver) {
                    RenderedWebElement element = null;
                    for (int i = 0; i < locators.length; ++i) {
                        try {
                            element = (RenderedWebElement)driver.findElement(locators[i]);
                        }
                        catch (NotFoundException e) {
                            if (!all) continue;
                            return null;
                        }
                        if (element.isDisplayed()) {
                            if (all) continue;
                            return element;
                        }
                        if (!all) continue;
                        return null;
                    }
                    return element;
                }
            });
        }
        catch (TimeoutException e) {
            StringBuffer sb = new StringBuffer("Failed to find the following locators: [\n");
            for (By by : locators) {
                sb.append(by).append("\n");
            }
            sb.append("] in the source [\n");
            sb.append(this.getDriver().getPageSource());
            sb.append("\n]");
            throw new TimeoutException(sb.toString(), (Throwable)e);
        }
    }

    public void waitUntilElementDisappears(By locator) {
        this.waitUntilElementDisappears(locator, this.getUtil().getTimeout());
    }

    public void waitUntilElementDisappears(final By locator, int timeout) {
        WebDriverWait wait = new WebDriverWait(this.getDriver(), (long)timeout);
        wait.until((Function)new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    RenderedWebElement element = (RenderedWebElement)driver.findElement(locator);
                    return !element.isDisplayed();
                }
                catch (NotFoundException e) {
                    return Boolean.TRUE;
                }
                catch (StaleElementReferenceException e) {
                    return Boolean.TRUE;
                }
            }
        });
    }

    public void makeElementVisible(By locator) {
        this.makeElementVisible(this.getDriver().findElement(locator));
    }

    public void makeElementVisible(WebElement element) {
        this.executeJavascript("arguments[0].style.visibility='visible'", element);
    }

    public void waitUntilElementHasAttributeValue(By locator, String attributeName, String expectedValue) {
        this.waitUntilElementHasAttributeValue(locator, attributeName, expectedValue, this.getUtil().getTimeout());
    }

    public void waitUntilElementHasAttributeValue(final By locator, final String attributeName, final String expectedValue, int timeout) {
        WebDriverWait wait = new WebDriverWait(this.getDriver(), (long)timeout);
        wait.until((Function)new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    RenderedWebElement element = (RenderedWebElement)driver.findElement(locator);
                    return expectedValue.equals(element.getAttribute(attributeName));
                }
                catch (NotFoundException e) {
                    return Boolean.TRUE;
                }
            }
        });
    }

    public void waitUntilElementHasTextContent(By locator, String expectedValue) {
        this.waitUntilElementHasTextContent(locator, expectedValue, this.getUtil().getTimeout());
    }

    public void waitUntilElementHasTextContent(final By locator, final String expectedValue, int timeout) {
        WebDriverWait wait = new WebDriverWait(this.getDriver(), (long)timeout);
        wait.until((Function)new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                RenderedWebElement element = (RenderedWebElement)driver.findElement(locator);
                return expectedValue.equals(element.getText());
            }
        });
    }

    public Object executeJavascript(String javascript, Object ... arguments) {
        if (!(this.getDriver() instanceof JavascriptExecutor)) {
            throw new RuntimeException("Currently used web driver (" + this.getDriver().getClass() + ") does not support JavaScript execution");
        }
        JavascriptExecutor js = (JavascriptExecutor)this.getDriver();
        if (!js.isJavascriptEnabled()) {
            throw new RuntimeException("JavaScript is disabled");
        }
        return js.executeScript(javascript, arguments);
    }

    protected void makeConfirmDialogSilent() {
        ((JavascriptExecutor)this.getDriver()).executeScript("window.confirm = function() { return true; }", new Object[0]);
    }
}

