/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.it.ui.framework.elements;

import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;
import org.xwiki.it.ui.framework.elements.BaseElement;
import org.xwiki.it.ui.framework.elements.InlinePage;
import org.xwiki.it.ui.framework.elements.editor.ClassEditPage;
import org.xwiki.it.ui.framework.elements.editor.ObjectEditPage;
import org.xwiki.it.ui.framework.elements.editor.WYSIWYGEditPage;
import org.xwiki.it.ui.framework.elements.editor.WikiEditPage;

public class BasePage
extends BaseElement {
    public String getPageTitle() {
        return this.getDriver().getTitle();
    }

    public String getPageURL() {
        return this.getDriver().getCurrentUrl();
    }

    public String getMetaDataValue(String metaName) {
        return this.getDriver().findElement(By.xpath((String)("//meta[@name='" + metaName + "']"))).getAttribute("content");
    }

    public boolean isAuthenticated() {
        return !this.getDriver().findElements(By.id((String)"tmUser")).isEmpty();
    }

    public boolean isNewDocument() {
        JavascriptExecutor js = (JavascriptExecutor)this.getDriver();
        return (Boolean)js.executeScript("return XWiki.docisnew", new Object[0]);
    }

    protected void hoverOverMenu(String menuId) {
        WebElement spaceMenuDiv = this.getDriver().findElement(By.id((String)menuId));
        this.executeScript("showsubmenu(arguments[0])", spaceMenuDiv);
    }

    public Object executeScript(String script, Object ... arguments) {
        if (!(this.getDriver() instanceof JavascriptExecutor)) {
            throw new RuntimeException("This test only works with a Javascript-enabled Selenium2 Driver");
        }
        return ((JavascriptExecutor)this.getDriver()).executeScript(script, arguments);
    }

    protected void clickContentMenuTopEntry(String id) {
        this.getDriver().findElement(By.xpath((String)("//div[@id='" + id + "']//strong"))).click();
    }

    protected void clickContentMenuEditSubMenuEntry(String id) {
        this.hoverOverMenu("tmEdit");
        this.getDriver().findElement(By.xpath((String)("//a[@id='" + id + "']"))).click();
    }

    public void clickEdit() {
        this.clickContentMenuTopEntry("tmEdit");
    }

    public WikiEditPage clickEditWiki() {
        this.clickContentMenuEditSubMenuEntry("tmEditWiki");
        return new WikiEditPage();
    }

    public WYSIWYGEditPage clickEditWysiwyg() {
        this.clickContentMenuEditSubMenuEntry("tmEditWysiwyg");
        return new WYSIWYGEditPage();
    }

    public InlinePage clickEditInline() {
        this.clickContentMenuEditSubMenuEntry("tmEditInline");
        return new InlinePage();
    }

    public void clickEditRights() {
        this.clickContentMenuEditSubMenuEntry("tmEditRights");
    }

    public ObjectEditPage clickEditObjects() {
        this.clickContentMenuEditSubMenuEntry("tmEditObject");
        return new ObjectEditPage();
    }

    public ClassEditPage clickEditClass() {
        this.clickContentMenuEditSubMenuEntry("tmEditClass");
        return new ClassEditPage();
    }
}

