/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.it.ui.framework.elements.editor;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.it.ui.framework.elements.BasePage;
import org.xwiki.it.ui.framework.elements.FormElement;
import org.xwiki.it.ui.framework.elements.ViewPage;
import org.xwiki.it.ui.framework.elements.editor.DatabaseListClassEditElement;
import org.xwiki.it.ui.framework.elements.editor.NumberClassEditElement;

public class ClassEditPage
extends BasePage {
    @FindBy(name="action_saveandcontinue")
    private WebElement saveandcontinue;
    @FindBy(name="action_propupdate")
    private WebElement saveandview;
    @FindBy(name="action_cancel")
    private WebElement cancel;
    @FindBy(id="propupdate")
    private WebElement propertyForm;
    @FindBy(id="propname")
    private WebElement propertyNameField;
    @FindBy(id="proptype")
    private WebElement propertyTypeField;
    @FindBy(name="action_propadd")
    private WebElement propertySubmit;
    private FormElement form;

    public void addProperty(String propertyName, String propertyType) {
        this.getForm().setFieldValue(this.propertyNameField, propertyName);
        this.getForm().setFieldValue(this.propertyTypeField, propertyType);
        this.propertySubmit.click();
        this.waitUntilElementIsVisible(By.id((String)("xproperty_" + propertyName)));
    }

    public void deleteProperty(String propertyName) {
        By propertyLocator = By.id((String)("xproperty_" + propertyName));
        WebElement propertyContainer = this.getDriver().findElement(propertyLocator);
        WebElement deleteLink = propertyContainer.findElement(By.className((String)"delete"));
        deleteLink.click();
        this.waitUntilElementIsVisible(By.className((String)"xdialog-box-confirmation"));
        this.getDriver().findElement(By.cssSelector((String)".xdialog-box-confirmation input[value='Yes']")).click();
        this.waitUntilElementDisappears(propertyLocator);
    }

    private FormElement getForm() {
        if (this.form == null) {
            this.form = new FormElement(this.propertyForm);
        }
        return this.form;
    }

    public void switchToEdit(String space, String page) {
        this.getUtil().gotoPage(space, page, "edit", "editor=class");
    }

    public DatabaseListClassEditElement getDatabaseListClassEditElement(String propertyName) {
        By locator = By.id((String)("xproperty_" + propertyName + "_title"));
        this.waitUntilElementIsVisible(locator);
        this.getDriver().findElement(locator).click();
        return new DatabaseListClassEditElement(this.getForm(), propertyName);
    }

    public NumberClassEditElement getNumberClassEditElement(String propertyName) {
        By locator = By.id((String)("xproperty_" + propertyName + "_title"));
        this.waitUntilElementIsVisible(locator);
        this.getDriver().findElement(locator).click();
        return new NumberClassEditElement(this.getForm(), propertyName);
    }

    public void clickSaveAndContinue() {
        this.saveandcontinue.click();
        this.waitUntilElementIsVisible(By.xpath((String)"//div[contains(@class,'xnotification-done') and text()='Saved']"));
    }

    public ViewPage clickSaveAndView() {
        this.saveandview.click();
        return new ViewPage();
    }

    public ViewPage clickCancel() {
        this.cancel.click();
        return new ViewPage();
    }
}

