/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.it.ui.invitation.elements;

import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.it.ui.framework.elements.BasePage;
import org.xwiki.it.ui.framework.elements.TableElement;
import org.xwiki.it.ui.invitation.elements.InvitationActionConfirmationElement;
import org.xwiki.it.ui.invitation.elements.InvitationFooterElement;
import org.xwiki.it.ui.invitation.elements.InvitationMessageDisplayElement;

public abstract class InspectInvitationsPage
extends BasePage {
    private InvitationFooterElement footer = new InvitationFooterElement();
    @FindBy(tagName="table")
    private WebElement tableWebEl;

    public TableElement getTable() {
        return new TableElement(this.tableWebEl);
    }

    public InvitationFooterElement getFooter() {
        return this.footer;
    }

    public String getStatusAndMemo() {
        List elements = this.getDriver().findElements(By.id((String)"message-status-and-memo"));
        if (elements.size() > 0) {
            return ((WebElement)elements.get(0)).getText();
        }
        return null;
    }

    public OneMessage getMessageWhere(String columnName, String value) {
        ArrayList<String> columnEntries = new ArrayList<String>();
        List<WebElement> column = this.getTable().getColumn(columnName);
        for (WebElement cell : column) {
            if (cell.getText().equals(value)) {
                WebElement link = (WebElement)this.getTable().getColumn("Subject").get(column.indexOf(cell)).findElements(By.tagName((String)"a")).get(0);
                link.click();
                return null;
            }
            columnEntries.add(cell.getText());
        }
        throw new WebDriverException("Could not find message with " + column + " equal to " + value + "\nIn columbn with entries: " + ((Object)columnEntries).toString());
    }

    protected TableElement clickMessageHistory() {
        ((WebElement)this.getTable().getColumn("Message History").get(1).findElements(By.tagName((String)"a")).get(0)).click();
        return new TableElement(this.getDriver().findElement(By.id((String)"message-history-table")).findElement(By.tagName((String)"table")));
    }

    public static class AsUser
    extends InspectInvitationsPage {
        @FindBy(name="doAction_cancel")
        protected WebElement cancelButton;

        public OneMessage getMessageWhere(String column, String value) {
            super.getMessageWhere(column, value);
            return new OneMessage();
        }

        public class OneMessage
        extends AsUser
        implements org.xwiki.it.ui.invitation.elements.InspectInvitationsPage$OneMessage {
            @FindBy(id="invitation-displaymessage")
            private WebElement preview;

            public InvitationMessageDisplayElement getMessage() {
                return new InvitationMessageDisplayElement(this.preview);
            }

            public TableElement clickMessageHistory() {
                return super.clickMessageHistory();
            }

            public InvitationActionConfirmationElement cancel() {
                this.cancelButton.click();
                return new InvitationActionConfirmationElement();
            }

            public String notSpam(String message) {
                throw new WebDriverException("Function only possible for admin.");
            }
        }
    }

    public static class AsAdmin
    extends InspectInvitationsPage {
        public OneMessage getMessageWhere(String column, String value) {
            super.getMessageWhere(column, value);
            return new OneMessage();
        }

        public class OneMessage
        extends AsAdmin
        implements org.xwiki.it.ui.invitation.elements.InspectInvitationsPage$OneMessage {
            @FindBy(id="invitation-displaymessage")
            private WebElement preview;
            @FindBy(name="doAction_notSpam")
            private WebElement notSpamButton;

            public InvitationMessageDisplayElement getMessage() {
                return new InvitationMessageDisplayElement(this.preview);
            }

            public TableElement clickMessageHistory() {
                return super.clickMessageHistory();
            }

            public InvitationActionConfirmationElement cancel() {
                throw new WebDriverException("Invitation cannot be canceled as an admin");
            }

            public String notSpam(String message) {
                this.notSpamButton.click();
                InvitationActionConfirmationElement confirm = new InvitationActionConfirmationElement();
                if (!confirm.getLabel().equals("Synopsis of findings and/or action taken")) {
                    throw new WebDriverException("Not on 'not spam' confirm page, message says: " + confirm.getLabel());
                }
                confirm.setMemo(message);
                return confirm.confirm();
            }
        }
    }

    public static interface OneMessage {
        public InvitationMessageDisplayElement getMessage();

        public String notSpam(String var1);

        public InvitationActionConfirmationElement cancel();

        public String getStatusAndMemo();

        public TableElement clickMessageHistory();
    }
}

