/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.it.ui.invitation.elements;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.it.ui.framework.elements.BaseElement;
import org.xwiki.it.ui.invitation.elements.InspectInvitationsPage;

public class InvitationFooterElement
extends BaseElement {
    @FindBy(id="invitation-footer")
    private WebElement footer;
    @FindBy(id="HTools")
    private WebElement toolsHeader;
    @FindBy(xpath="//div[@id='invitation-footer']//a[@href='/xwiki/bin/view/Invitation/InvitationMemberActions?inspect=all']")
    private WebElement inspectAll;
    @FindBy(xpath="//div[@id='invitation-footer']//a[@href='/xwiki/bin/view/Invitation/InvitationMemberActions?inspect=allAsAdmin']")
    private WebElement inspectAllAsAdmin;

    public boolean isAdmin() {
        return !this.footer.findElements(By.id((String)"HAdministrativeTools")).isEmpty();
    }

    public InspectInvitationsPage inspectMyInvitations() {
        this.inspectAll.click();
        return new InspectInvitationsPage.AsUser();
    }

    public InspectInvitationsPage inspectAllInvitations() {
        if (!this.isAdmin()) {
            throw new WebDriverException("Inspection as admin impossible because user is not admin.");
        }
        this.inspectAllAsAdmin.click();
        return new InspectInvitationsPage.AsAdmin();
    }

    public int myPendingInvitations() {
        if (this.footer.findElements(By.id((String)"my-pending-invitations")).size() == 0) {
            return 0;
        }
        String message = ((WebElement)this.footer.findElements(By.id((String)"my-pending-invitations")).get(0)).getText().trim();
        return Integer.parseInt(message.substring(0, message.indexOf(" pending")));
    }

    public int spamReports() {
        if (this.footer.findElements(By.id((String)"spam-reports")).size() == 0) {
            return 0;
        }
        String message = ((WebElement)this.footer.findElements(By.id((String)"spam-reports")).get(0)).getText().trim();
        return Integer.parseInt(message.substring(0, message.indexOf(" reported as spam")));
    }
}

