/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.it.ui.invitation.elements;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.xwiki.it.ui.framework.elements.BaseElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvitationMessageDisplayElement
extends BaseElement {
    private WebElement displayElement;

    public InvitationMessageDisplayElement(WebElement displayElement) {
        this.displayElement = displayElement;
    }

    public List<WebElement> getAllRecipients() {
        return this.displayElement.findElement(By.id((String)"preview-to-field")).findElements(By.tagName((String)"span"));
    }

    public List<WebElement> getValidRecipients() {
        return this.displayElement.findElement(By.id((String)"preview-to-field")).findElements(By.className((String)"valid-address"));
    }

    public List<WebElement> getInvalidRecipients() {
        return this.displayElement.findElement(By.id((String)"preview-to-field")).findElements(By.className((String)"invalid-address"));
    }

    public boolean isRecipientValid(String email) {
        for (WebElement recip : this.getAllRecipients()) {
            if (!recip.getText().contains(email)) continue;
            return recip.getAttribute("class").contains("valid-address");
        }
        throw new WebDriverException("Recipient name (" + email + ") not found.");
    }

    public String getInvalidAddressMessage() {
        return this.displayElement.findElement(By.id((String)"invalid-address-message")).getText();
    }

    public String getSubjectLine() {
        return this.displayElement.findElement(By.id((String)"preview-subjectline-field")).getText();
    }

    public String getMessageBody() {
        return this.displayElement.findElement(By.id((String)"preview-messagebody-field")).getText();
    }
}

