/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.it.ui.framework.elements;

import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.it.ui.framework.elements.BaseElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentsPane
extends BaseElement {
    @FindBy(id="Attachmentspane")
    private WebElement pane;
    @FindBy(xpath="//input[@value='Add another file']")
    private WebElement addAnotherFile;

    public void setFileToUpload(String filePath) {
        List inputs = this.pane.findElements(By.className((String)"uploadFileInput"));
        ((WebElement)inputs.get(inputs.size() - 1)).sendKeys(new CharSequence[]{filePath});
    }

    public void addAnotherFile() {
        this.addAnotherFile.click();
    }

    public void clickAttachFiles() {
        this.pane.findElement(By.xpath((String)"//div/span/input[@class='button'][@type='submit'][@value='Attach']")).click();
    }

    public List<String> getAttachmentFilenames() {
        ArrayList<String> names = new ArrayList<String>();
        for (WebElement el : this.pane.findElements(By.className((String)"information"))) {
            names.add(el.findElement(By.className((String)"name")).getText());
        }
        return names;
    }

    public List<WebElement> getAttachmentLinks() {
        ArrayList<WebElement> links = new ArrayList<WebElement>();
        for (WebElement el : this.pane.findElements(By.className((String)"information"))) {
            links.add(el.findElement(By.className((String)"name")).findElement(By.tagName((String)"a")));
        }
        return links;
    }

    public void deleteAttachmentByFileByName(String attachmentName) {
        this.waitUntilElementIsVisible(By.xpath((String)"//li[@id='Attachmentstab']"));
        this.waitUntilElementIsVisible(By.xpath((String)("//div[@id='attachmentscontent']//a[text()='" + attachmentName + "']/../../span[2]/a[@class='deletelink']")));
        this.getDriver().findElement(By.xpath((String)("//div[@id='attachmentscontent']//a[text()='" + attachmentName + "']/../../span[2]/a[@class='deletelink']"))).click();
        this.waitUntilElementIsVisible(By.xpath((String)"//*[@class='xdialog-modal-container']/*[contains(@class, 'xdialog-box-confirmation')]"));
        this.getDriver().findElement(By.xpath((String)"//*[@class='xdialog-modal-container']//input[@value='Yes']")).click();
        this.waitUntilElementDisappears(By.xpath((String)"//*[@class='xdialog-modal-container']/*[contains(@class, 'xdialog-box-confirmation')]"));
        this.waitUntilElementDisappears(By.xpath((String)("//div[@id='attachmentscontent']//a[text()='" + attachmentName + "']")));
        this.waitUntilElementIsVisible(By.xpath((String)"//div[@id='Attachmentspane']"));
    }

    public void deleteFirstAttachment() {
        this.waitUntilElementIsVisible(By.xpath((String)"//div[@id='Attachmentspane']"));
        String tmp = this.getDriver().findElement(By.xpath((String)"//div[@id='_attachments']/*[1]/div[@class='information']/span[@class='name']")).getText();
        this.getDriver().findElement(By.xpath((String)("//div[@id='attachmentscontent']//a[text()='" + tmp + "']/../../span[2]/a[@class='deletelink']"))).click();
        this.waitUntilElementIsVisible(By.className((String)"xdialog-box-confirmation"));
        this.waitUntilElementIsVisible(By.xpath((String)"//*[@class='xdialog-modal-container']/*[contains(@class, 'xdialog-box-confirmation')]"), 20);
        this.getDriver().findElement(By.xpath((String)"//*[@class='xdialog-modal-container']//input[@value='Yes']")).click();
        this.waitUntilElementDisappears(By.xpath((String)"//*[@class='xdialog-modal-container']/*[contains(@class, 'xdialog-box-confirmation')]"));
        this.waitUntilElementDisappears(By.xpath((String)("//div[@id='attachmentscontent']//a[text()='" + tmp + "']/../../span[2]/a[@class='deletelink']")));
    }

    public int getNumberOfAttachments() {
        this.waitUntilElementIsVisible(By.xpath((String)"//div[@id='Attachmentspane']"));
        By countLocator = By.cssSelector((String)"#Attachmentstab .itemCount");
        return Integer.parseInt(this.getDriver().findElement(countLocator).getText().replaceAll("[()]", ""));
    }

    public void deleteAllAttachments() {
        while (this.getNumberOfAttachments() > 0) {
            this.deleteFirstAttachment();
        }
    }

    public String getUploaderOfAttachment(String attachmentName) {
        this.waitUntilElementIsVisible(By.xpath((String)"//div[@id='Attachmentspane']"));
        this.waitUntilElementIsVisible(By.xpath((String)("//div[@id='attachmentscontent']//a[text()='" + attachmentName + "']/../../span[2]/a[@class='deletelink']")));
        return this.getDriver().findElement(By.xpath((String)("//div[@id='attachmentscontent']//a[text()='" + attachmentName + "']/../../div[@class='meta']/span[@class='publisher']/span[@class='wikilink']"))).toString();
    }

    public String getLatestVersionOfAttachment(String attachmentName) {
        this.waitUntilElementIsVisible(By.xpath((String)"//div[@id='Attachmentspane']"));
        return this.getDriver().findElement(By.xpath((String)("//div[@id='attachmentscontent']//a[text()= '" + attachmentName + "']/../../span[3]/a"))).getText();
    }

    public String getSizeOfAttachment(String attachmentName) {
        this.waitUntilElementIsVisible(By.xpath((String)"//div[@id='Attachmentspane']"));
        return this.getDriver().findElement(By.xpath((String)("//div[@id='attachmentscontent']//a[text()='" + attachmentName + "']/../../div[@class='meta']/span[@class='size']"))).toString().replaceAll("[()]", "");
    }

    public String getDateOfLastUpload(String attachmentName) {
        this.waitUntilElementIsVisible(By.xpath((String)"//div[@id='Attachmentspane']"));
        return this.getDriver().findElement(By.xpath((String)("//div[@id='attachmentscontent']//a[text()='" + attachmentName + "']/../../div[@class='meta']/span[@class='date']"))).toString().replaceFirst("on", "");
    }

    public boolean attachmentExistsByFileName(String attachmentName) {
        try {
            this.getDriver().findElement(By.xpath((String)("//a[@title='Download this attachment' and text()='" + attachmentName + "']")));
        }
        catch (NoSuchElementException e) {
            return false;
        }
        return true;
    }
}

