/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.it.ui.framework.elements;

import java.util.List;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.TimeoutException;
import org.xwiki.it.ui.framework.elements.BaseElement;

public class LiveTableElement
extends BaseElement {
    private String livetableId;

    public LiveTableElement(String livetableId) {
        this.livetableId = livetableId;
        Assert.assertTrue((String)"Invalid state, the livetable shouldn't be in a displayed state", (this.getDriver().findElements(By.id((String)"uitest-livetable-status")).size() == 0 ? 1 : 0) != 0);
        this.executeJavascript("document.observe('xwiki:livetable:" + this.livetableId + ":displayComplete', function() {" + "document.body.insert(new Element('div', {'id' : 'uitest-livetable-status' }).update('complete'));});", new Object[0]);
    }

    public boolean isReady() {
        boolean ready = false;
        List elements = this.getDriver().findElements(By.id((String)"uitest-livetable-status"));
        if (elements.size() > 0) {
            ready = "complete".equals(((WebElement)elements.get(0)).getText());
        }
        return ready;
    }

    public void waitUntilReady() {
        long t1 = System.currentTimeMillis();
        while (System.currentTimeMillis() - t1 < (long)this.getUtil().getTimeout() * 1000L) {
            if (this.isReady()) {
                this.clearStatus();
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        throw new TimeoutException("Livetable isn't ready after the timeout has expired. Source [" + this.getDriver().getPageSource() + "]");
    }

    public boolean hasColumn(String columnTitle) {
        List elements = this.getDriver().findElements(By.xpath((String)("//th[contains(@class, 'xwiki-livetable-display-header-text') and normalize-space(text()) = '" + columnTitle + "']")));
        return elements.size() > 0;
    }

    public void filterColumn(String inputId, String filterValue) {
        this.clearStatus();
        WebElement element = this.getDriver().findElement(By.id((String)inputId));
        element.sendKeys(new CharSequence[]{filterValue});
        this.waitUntilReady();
    }

    private void clearStatus() {
        this.executeJavascript("if ($('uitest-livetable-status')) $('uitest-livetable-status').remove();", new Object[0]);
    }
}

