/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.it.ui.framework.elements.editor;

import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.it.ui.framework.elements.BasePage;
import org.xwiki.it.ui.framework.elements.ViewPage;

public class EditPage
extends BasePage {
    @FindBy(name="action_saveandcontinue")
    private WebElement saveandcontinue;
    @FindBy(name="action_save")
    private WebElement save;
    @FindBy(name="action_cancel")
    private WebElement cancel;
    @FindBy(xpath="//*[@id = 'tmCurrentEditor']//*[@class = 'tme hastype']")
    private WebElement selectedEditMenuItem;

    public void clickSaveAndContinue() {
        this.saveandcontinue.click();
        this.waitUntilElementIsVisible(By.xpath((String)"//div[contains(@class,'xnotification-done') and text()='Saved']"));
    }

    public ViewPage clickSaveAndView() {
        this.save.click();
        return new ViewPage();
    }

    public ViewPage clickCancel() {
        this.cancel.click();
        return new ViewPage();
    }

    public Editor getEditor() {
        return Editor.valueOf(this.selectedEditMenuItem.getText().toUpperCase());
    }

    protected void clickContentMenuEditSubMenuEntry(String id) {
        this.hoverOverMenu("tmCurrentEditor");
        this.getDriver().findElement(By.xpath((String)("//a[@id='" + id + "']"))).click();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Editor {
        WYSIWYG("WYSIWYG"),
        WIKI("Wiki"),
        RIGHTS("Access Rights"),
        OBJECT("Objects"),
        CLASS("Class");

        private static final Map<String, Editor> BY_PRETTY_NAME;
        private final String prettyName;

        private Editor(String prettyName) {
            this.prettyName = prettyName;
        }

        public String getPrettyName() {
            return this.prettyName;
        }

        public static Editor byPrettyName(String prettyName) {
            return BY_PRETTY_NAME.get(prettyName);
        }

        static {
            BY_PRETTY_NAME = new HashMap<String, Editor>();
            for (Editor editor : Editor.values()) {
                BY_PRETTY_NAME.put(editor.getPrettyName(), editor);
            }
        }
    }
}

