/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.it.ui.framework.elements.editor;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.xwiki.it.ui.framework.elements.FormElement;
import org.xwiki.it.ui.framework.elements.editor.EditPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectEditPage
extends EditPage {
    @FindBy(id="update")
    private WebElement objectForm;
    @FindBy(id="classname")
    private WebElement classNameField;
    @FindBy(name="action_objectadd")
    private WebElement classNameSubmit;
    private FormElement form;

    public FormElement addObject(String className) {
        this.getForm().setFieldValue(this.classNameField, className);
        final By objectsLocator = By.cssSelector((String)("[id='xclass_" + className + "'] .xobject"));
        final int initialObjectCount = this.getDriver().findElements(objectsLocator).size();
        this.classNameSubmit.click();
        WebDriverWait wait = new WebDriverWait(this.getDriver(), (long)this.getUtil().getTimeout());
        wait.until((Function)new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return driver.findElements(objectsLocator).size() > initialObjectCount;
            }
        });
        List<FormElement> objects = this.getObjectsOfClass(className);
        return objects.get(objects.size() - 1);
    }

    public FormElement addObjectFromInlineLink(String className) {
        final By objectsLocator = By.cssSelector((String)("[id='xclass_" + className + "'] .xobject"));
        final int initialObjectCount = this.getDriver().findElements(objectsLocator).size();
        this.getDriver().findElement(By.cssSelector((String)("[id='add_xobject_" + className + "'] .xobject-add-control"))).click();
        WebDriverWait wait = new WebDriverWait(this.getDriver(), (long)this.getUtil().getTimeout());
        wait.until((Function)new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return driver.findElements(objectsLocator).size() > initialObjectCount;
            }
        });
        List<FormElement> objects = this.getObjectsOfClass(className);
        return objects.get(objects.size() - 1);
    }

    public void deleteObject(String className, int index) {
        By objectLocator = By.id((String)("xobject_" + className + "_" + index));
        WebElement objectContainer = this.getDriver().findElement(objectLocator);
        WebElement deleteLink = objectContainer.findElement(By.className((String)"delete"));
        deleteLink.click();
        this.waitUntilElementIsVisible(By.className((String)"xdialog-box-confirmation"));
        this.getDriver().findElement(By.cssSelector((String)".xdialog-box-confirmation input[value='Yes']")).click();
        this.waitUntilElementDisappears(objectLocator);
    }

    public void removeAllDeprecatedProperties() {
        this.getDriver().findElement(By.className((String)"syncAllProperties")).click();
        this.waitUntilElementDisappears(By.className((String)"deprecatedProperties"));
    }

    private FormElement getForm() {
        if (this.form == null) {
            this.form = new FormElement(this.objectForm);
        }
        return this.form;
    }

    public String getURL(String space, String page) {
        return this.getUtil().getURL(space, page, "edit", "editor=object");
    }

    public List<FormElement> getObjectsOfClass(String className) {
        List titles = this.getDriver().findElement(By.id((String)("xclass_" + className))).findElements(By.className((String)"xobject-title"));
        List elements = this.getDriver().findElement(By.id((String)("xclass_" + className))).findElements(By.className((String)"xobject-content"));
        ArrayList<FormElement> forms = new ArrayList<FormElement>(elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            WebElement element = (WebElement)elements.get(i);
            if (element instanceof RenderedWebElement && !((RenderedWebElement)element).isDisplayed()) {
                ((WebElement)titles.get(i)).click();
            }
            forms.add(new FormElement(element));
        }
        return forms;
    }

    public void switchToEdit(String space, String page) {
        this.getUtil().gotoPage(space, page, "edit", "editor=object");
    }
}

