/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.it.ui.framework.elements.editor;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.it.ui.framework.elements.LiveTableElement;
import org.xwiki.it.ui.framework.elements.editor.EditPage;

public class RightsEditPage
extends EditPage {
    private LiveTableElement rightsTable;
    @FindBy(id="uorgu")
    private WebElement showUsersField;
    @FindBy(id="uorgg")
    private WebElement showGroupsField;

    public void switchToUsers() {
        LiveTableElement e = this.getRightsTable();
        this.showUsersField.click();
        e.waitUntilReady();
    }

    public void switchToGroups() {
        this.showGroupsField.click();
        this.getRightsTable().waitUntilReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State clickRight(String entityName, Right right) {
        try {
            this.executeJavascript("window.__oldConfirm = window.confirm; window.confirm = function() { return true; };", new Object[0]);
            By buttonLocator = By.xpath((String)("//*[@id='usersandgroupstable-display']//td[@class='username']/a[contains(@href, '" + entityName + "')]/../../td[" + right.getColumnIndex() + "]/img"));
            WebElement button = this.getDriver().findElement(buttonLocator);
            State expectedState = State.getButtonState(button).getNextState();
            button.click();
            this.waitUntilElementHasAttributeValue(buttonLocator, "src", expectedState.imageURL);
            State state = expectedState;
            return state;
        }
        finally {
            this.executeJavascript("window.confirm = window.__oldConfirm;", new Object[0]);
        }
    }

    public void setRight(String entityName, Right right, State wantedState) {
        State currentState;
        while ((currentState = this.clickRight(entityName, right)) != wantedState) {
        }
    }

    public String getURL(String space, String page) {
        return this.getUtil().getURL(space, page, "edit", "editor=rights");
    }

    public void switchToEdit(String space, String page) {
        this.getUtil().gotoPage(space, page, "edit", "editor=rights");
    }

    private LiveTableElement getRightsTable() {
        if (this.rightsTable == null) {
            this.rightsTable = new LiveTableElement("usersandgroupstable");
        }
        return this.rightsTable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NONE("/xwiki/resources/js/xwiki/usersandgroups/img/none.png"),
        ALLOW("/xwiki/resources/js/xwiki/usersandgroups/img/allow.png"),
        DENY("/xwiki/resources/js/xwiki/usersandgroups/img/deny1.png");

        String imageURL;

        private State(String imageURL) {
            this.imageURL = imageURL;
        }

        State getNextState() {
            return State.values()[(this.ordinal() + 1) % State.values().length];
        }

        static State getButtonState(WebElement button) {
            for (State s : State.values()) {
                if (!s.imageURL.equals(button.getAttribute("src"))) continue;
                return s;
            }
            return NONE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Right {
        VIEW,
        COMMENT,
        EDIT,
        DELETE;


        int getColumnIndex() {
            return this.ordinal() + 2;
        }
    }
}

