/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.it.ui.invitation.elements;

import java.util.HashMap;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.it.ui.framework.elements.BasePage;
import org.xwiki.it.ui.framework.elements.FormElement;
import org.xwiki.it.ui.framework.elements.TableElement;
import org.xwiki.it.ui.invitation.elements.InvitationFooterElement;
import org.xwiki.it.ui.invitation.elements.InvitationMessageDisplayElement;

public class InvitationSenderPage
extends BasePage {
    @FindBy(id="invitation-sender-form")
    private WebElement form;
    private FormElement formElement;
    @FindBy(xpath="//form[@id='invitation-sender-form']/div/div/span/input[@type='submit'][@name='preview']")
    private WebElement previewButton;
    @FindBy(xpath="//form[@id='invitation-sender-form']/div/div/span/input[@type='submit'][@name='sendMail']")
    private WebElement sendButton;
    @FindBy(id="invitation-displaymessage")
    private WebElement preview;
    private InvitationMessageDisplayElement previewElement;

    public void gotoPage() {
        this.getDriver().get(this.getURL());
    }

    public String getURL() {
        return this.getUtil().getURL("Invitation", "WebHome");
    }

    public boolean userIsSpammer() {
        for (WebElement error : this.getDriver().findElements(By.id((String)"invitation-permission-error"))) {
            if (!error.getText().equals("A message which you sent was reported as spam and your privilege to send mail has been suspended pending investigation, we apologize for the inconvenience.")) continue;
            return true;
        }
        return false;
    }

    public void fillInDefaultValues() {
        this.fillForm("user@localhost.localdomain", "This is a subject line.", "This is my message");
    }

    public void fillForm(String recipients, String subjectLine, String messageBody) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (recipients != null) {
            map.put("recipients", recipients);
        }
        if (subjectLine != null) {
            map.put("subjectLine", subjectLine);
        }
        if (messageBody != null) {
            map.put("messageBody", messageBody);
        }
        this.getForm().fillFieldsByName(map);
    }

    public InvitationSentPage send() {
        this.sendButton.click();
        return new InvitationSentPage();
    }

    public InvitationMessageDisplayElement preview() {
        this.previewButton.click();
        if (this.previewElement == null) {
            this.previewElement = new InvitationMessageDisplayElement(this.preview);
        }
        return this.previewElement;
    }

    public FormElement getForm() {
        if (this.formElement == null) {
            this.formElement = new FormElement(this.form);
        }
        return this.formElement;
    }

    public InvitationFooterElement getFooter() {
        return new InvitationFooterElement();
    }

    public class InvitationSentPage
    extends BasePage {
        @FindBy(id="invitation-action-message")
        private WebElement messageBox;
        @FindBy(xpath="//div[@class='message-table']/table")
        private WebElement table;

        public String getMessageBoxContent() {
            return this.messageBox.getText();
        }

        public TableElement getTable() {
            return new TableElement(this.table);
        }
    }
}

