/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.it.ui.xe.elements;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.it.ui.framework.elements.BaseElement;
import org.xwiki.it.ui.framework.elements.editor.WYSIWYGEditPage;
import org.xwiki.it.ui.xe.elements.SpaceIndexPage;

public class SpacesPane
extends BaseElement {
    @FindBy(linkText="Create a new space")
    private WebElement spaceCreateFormToggleSwitch;
    @FindBy(id="spSpaceCreateTextInput")
    private WebElement spaceNameTextField;

    public WYSIWYGEditPage createSpace(String spaceName) {
        this.spaceCreateFormToggleSwitch.click();
        this.spaceNameTextField.clear();
        this.spaceNameTextField.sendKeys(new CharSequence[]{spaceName});
        this.spaceNameTextField.submit();
        return new WYSIWYGEditPage();
    }

    public SpaceIndexPage clickSpaceIndex(String spaceName) {
        String escapedSpaceName = this.getUtil().escapeURL(spaceName);
        for (WebElement liElement : this.getDriver().findElements(By.xpath((String)"//li[contains(@class, 'xitem')]"))) {
            List elements = liElement.findElements(By.xpath((String)("//a[contains(@href, 'SpaceIndex?space=" + escapedSpaceName + "')]")));
            if (elements.isEmpty()) continue;
            this.executeJavascript("arguments[0].setAttribute('class', '')", liElement);
            ((WebElement)elements.get(0)).click();
            return new SpaceIndexPage();
        }
        throw new RuntimeException("Was unable to click on space index for [" + spaceName + "]");
    }
}

