/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.it;

import com.xpn.xwiki.it.framework.AbstractValidationTest;
import com.xpn.xwiki.it.framework.CustomDutchWebGuidelinesValidator;
import java.io.ByteArrayInputStream;
import java.net.URLEncoder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.xwiki.validator.ValidationError;
import org.xwiki.validator.Validator;

public class DutchWebGuidelinesValidationTest
extends AbstractValidationTest {
    private CustomDutchWebGuidelinesValidator validator;

    public DutchWebGuidelinesValidationTest(String fullPageName, HttpClient client, Validator validator) throws Exception {
        super("testDocumentValidity");
        this.validator = (CustomDutchWebGuidelinesValidator)validator;
        this.fullPageName = fullPageName;
        this.client = client;
    }

    public String getName() {
        return "Validating Dutch Web Guidelines Validity for: " + this.fullPageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDocumentValidity() throws Exception {
        byte[] responseBody;
        GetMethod method = new GetMethod("http://127.0.0.1:8080/xwiki/bin/view/" + URLEncoder.encode(this.fullPageName, "UTF-8").replace('.', '/'));
        method.setDoAuthentication(true);
        method.setFollowRedirects(true);
        method.addRequestHeader("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])"Admin:admin".getBytes())));
        try {
            int statusCode = this.client.executeMethod((HttpMethod)method);
            DutchWebGuidelinesValidationTest.assertEquals((String)("Method failed: " + method.getStatusLine()), (int)200, (int)statusCode);
            responseBody = method.getResponseBody();
        }
        finally {
            method.releaseConnection();
        }
        this.validator.setFullPageName(this.fullPageName);
        this.validator.setDocument(new ByteArrayInputStream(responseBody));
        this.validator.validate();
        StringBuffer message = new StringBuffer();
        boolean isValid = true;
        message.append("Validation errors in " + this.fullPageName);
        for (ValidationError error : this.validator.getErrors()) {
            if (error.getType() == ValidationError.Type.WARNING) continue;
            isValid = false;
            message.append("\n" + error);
        }
        DutchWebGuidelinesValidationTest.assertTrue((String)message.toString(), (boolean)isValid);
    }
}

